/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.treasure;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.truelove.TrueLoveInfo;
import java.util.ArrayList;
import java.util.List;

public class TrueLoveGroupRankAdapter
extends BaseAdapter {
    private static final String TAG = "TrueLoveGroupRankAdapter";
    private Context mContext;
    private List<TrueLoveInfo.TreasureGroupRankInfo> mGroupRankList = new ArrayList<TrueLoveInfo.TreasureGroupRankInfo>();

    public TrueLoveGroupRankAdapter(Context mContext) {
        this.mContext = mContext;
    }

    public void addListData(List<TrueLoveInfo.TreasureGroupRankInfo> groupList) {
        if (groupList == null || groupList.size() == 0) {
            return;
        }
        this.mGroupRankList.addAll(groupList);
    }

    public void clearListData() {
        this.mGroupRankList.clear();
    }

    public int getCount() {
        return this.mGroupRankList.size();
    }

    public Object getItem(int position) {
        if (this.mGroupRankList != null && this.mGroupRankList.size() > position && position >= 0) {
            return this.mGroupRankList.get(position);
        }
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        RankItemHolder rankItemHolder;
        if (convertView == null) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"convertView=null", (Object[])new Object[0]);
            }
            rankItemHolder = new RankItemHolder();
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.truelove_item_grouprank, parent, false);
            rankItemHolder.rank = (TextView)convertView.findViewById(R.id.tv_rank);
            rankItemHolder.groupPic = (CircleImageView)convertView.findViewById(R.id.iv_groupPic);
            rankItemHolder.groupNick = (TextView)convertView.findViewById(R.id.tv_groupNick);
            rankItemHolder.groupScore = (TextView)convertView.findViewById(R.id.tv_groupScore);
            rankItemHolder.anchorNick = (TextView)convertView.findViewById(R.id.tv_anchorNick);
            convertView.setTag((Object)rankItemHolder);
        } else {
            rankItemHolder = (RankItemHolder)convertView.getTag();
        }
        TrueLoveInfo.TreasureGroupRankInfo info = (TrueLoveInfo.TreasureGroupRankInfo)this.getItem(position);
        if (info != null) {
            rankItemHolder.rank.setText((CharSequence)info.rank);
            ImageLoader.loadImage((String)info.cardpic, (RecycleImageView)rankItemHolder.groupPic, (ImageConfig)new ImageConfig(100, 100), (int)R.drawable.truelove_default_group_icon, (int)R.drawable.truelove_default_group_icon);
            rankItemHolder.groupNick.setText((CharSequence)info.groupname);
            rankItemHolder.groupScore.setText((CharSequence)this.mContext.getString(R.string.truelove_group_score, new Object[]{info.vitality}));
            rankItemHolder.anchorNick.setText((CharSequence)info.anchorNick);
        }
        return convertView;
    }

    static class RankItemHolder {
        TextView rank;
        CircleImageView groupPic;
        TextView groupNick;
        TextView groupScore;
        TextView anchorNick;

        RankItemHolder() {
        }
    }
}

