/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;

public class BagLayout
extends ViewGroup {
    private static final String TAG = "BagLayout";
    int columns = 4;
    int row = 2;
    int divider = 2;
    public int gridWidth = 0;
    int gridHeight = 0;
    int dividerColor;
    Paint paint;

    public BagLayout(Context context) {
        this(context, null);
    }

    public BagLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BagLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BagLayout);
            this.row = a.getInteger(R.styleable.BagLayout_row, 2);
            this.columns = a.getInteger(R.styleable.BagLayout_column, 5);
            a.recycle();
        }
        this.divider = (int)ResolutionUtils.convertDpToPixel((float)4.0f, (Context)this.getContext());
        this.paint = new Paint(1);
        this.dividerColor = this.getResources().getColor(R.color.common_color_10);
        this.paint.setColor(this.dividerColor);
        this.paint.setStrokeWidth((float)this.divider);
        this.paint.setStyle(Paint.Style.FILL);
    }

    public void setColumns(int columns) {
        this.columns = columns <= 1 ? 1 : columns;
        this.requestLayout();
    }

    public void setRow(int row) {
        this.row = row <= 1 ? 1 : row;
        this.requestLayout();
    }

    public void setDivider(int divider) {
        this.divider = divider;
    }

    public void setDividerColor(int color2) {
        this.dividerColor = color2;
        this.invalidate();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        if (childCount > this.row * this.columns) {
            childCount = this.row * this.columns;
        }
        for (int i = 0; i < this.row; ++i) {
            int childTop = i * (this.gridHeight + this.divider);
            for (int j = 0; j < this.columns; ++j) {
                int index = this.columns * i + j;
                if (index >= childCount) continue;
                View child = this.getChildAt(index);
                int childLeft = j * (this.gridWidth + this.divider);
                child.layout(childLeft, childTop, childLeft + this.gridWidth, childTop + this.gridHeight);
            }
        }
    }

    public void caculate() {
        this.gridWidth = (this.getMeasuredWidth() - (this.columns - 1) * this.divider) / this.columns;
        this.gridHeight = (this.getMeasuredHeight() - (this.row - 1) * this.divider) / this.row;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.caculate();
        int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.gridWidth, (int)0x40000000);
        int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.gridHeight, (int)0x40000000);
        int childCount = this.getChildCount();
        if (childCount > this.row * this.columns) {
            childCount = this.row * this.columns;
        }
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"dispatchDraw", (Object[])new Object[0]);
        }
        if (this.divider == 0) {
            return;
        }
        for (int i = 0; i < this.row - 1; ++i) {
            int t = (i + 1) * this.gridHeight + i * this.divider;
            canvas.drawLine(0.0f, (float)t, (float)this.getMeasuredWidth(), (float)(t + this.divider), this.paint);
        }
        for (int j = 0; j < this.columns - 1; ++j) {
            int l = (j + 1) * this.gridWidth + j * this.divider;
            canvas.drawLine((float)l, 0.0f, (float)(l + this.divider), (float)this.getBottom(), this.paint);
        }
    }
}

