/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicfunction.report;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.RequestParam;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.plugin.main.events.IReportClient_onReport_EventArgs;
import com.yy.mobile.plugin.main.events.IReportUploadClient_onUploadFail_EventArgs;
import com.yy.mobile.plugin.main.events.IReportUploadClient_onUploadSuccess_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.Temp;
import com.yy.mobile.ui.basicfunction.report.BaseModule;
import com.yy.mobile.ui.basicfunction.report.ReportModule$$EventBinder;
import com.yy.mobile.ui.basicfunction.report.ReportScreenShot;
import com.yy.mobile.ui.basicfunction.uicore.IBasicFunctionCore;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.widget.dialog.ReportPopupDialog;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.YYImageUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.LinkUriProvider;
import com.yymobile.core.basechannel.SoundReportHelper;
import com.yymobile.core.channel.ChannelState;
import com.yymobile.core.mic.uicore.IVirtualAudienceCore;
import com.yymobile.core.report.IReportCore;
import com.yymobile.core.user.IUserCore;
import com.yymobile.core.user.UserInfo;
import com.yymobile.core.utils.CommonParamUtil;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportModule
extends BaseModule
implements EventCompat {
    private static final String TAG = "ReportModule";
    private static final String CONTEXT = "ReportContext";
    private static final int BITMAP_LIMIT_SIZE = 0x100000;
    private static final float MAX_PIC_WIDTH = 720.0f;
    private static final int MSG_SAVE_SUCCESS = 1;
    private long sid;
    private String title = "";
    private long reportAnchorUid;
    protected ReportPopupDialog mReportPopupDialog;
    private ReportPopupDialog userReportPopupDialog;
    private String mBussinessId = "";
    private String filePath = "";
    private String fileName = "";
    protected String reportReason;
    private SafeDispatchHandler mHandler = new SafeDispatchHandler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                ReportModule.this.showReport(ReportModule.this.filePath);
            }
        }
    };
    private EventBinder mReportModuleSniperEventBinder;

    public void onEventBind() {
        if (this.mReportModuleSniperEventBinder == null) {
            this.mReportModuleSniperEventBinder = new ReportModule$$EventBinder();
        }
        this.mReportModuleSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mReportModuleSniperEventBinder != null) {
            this.mReportModuleSniperEventBinder.unBindEvent();
        }
    }

    public ReportModule(Activity activity) {
        super(activity);
        if (ICoreManagerBase.getChannelLinkCore().getChannelState() == ChannelState.In_Channel) {
            this.mBussinessId = Temp.getCurrentBussinessId();
        }
    }

    public void showReport() {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)("Activity = " + this.getActivity()), (Object[])new Object[0]);
            Toast.makeText((Context)this.getActivity(), (int)R.string.str_report_fail, (int)0).show();
            return;
        }
        this.screenshotAndSave().subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) throws Exception {
                Message message = Message.obtain();
                message.what = 1;
                ReportModule.this.mHandler.sendMessage(message);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                Toast.makeText((Context)ReportModule.this.getActivity(), (int)R.string.str_report_fail, (int)0).show();
                MLog.info((Object)ReportModule.TAG, (String)("report anchor fail\uff1a" + throwable.getMessage()), (Object[])new Object[0]);
            }
        });
    }

    protected Flowable<String> screenshotAndSave() {
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<Bitmap>(){

            public void subscribe(FlowableEmitter<Bitmap> emitter) throws Exception {
                long reportAnchorUid = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
                Bitmap bitmap = null;
                if (reportAnchorUid > 0L || ReportScreenShot.isMobileLiveMultiple()) {
                    bitmap = ReportScreenShot.getScreenSnapShot(ReportModule.this.getActivity());
                }
                if (bitmap != null) {
                    emitter.onNext((Object)bitmap);
                    emitter.onComplete();
                } else {
                    emitter.onError((Throwable)new IllegalStateException("\u622a\u56fe\u5931\u8d25"));
                }
            }
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER).subscribeOn(AndroidSchedulers.mainThread()).map((Function)new Function<Bitmap, String>(){

            public String apply(Bitmap bitmap) throws Exception {
                return ReportModule.this.saveScreenshot(bitmap);
            }
        });
    }

    public void showReport(final String path) {
        if (this.mBussinessId != null && !this.mBussinessId.isEmpty() && (this.mBussinessId.equals("general") || this.mBussinessId.equals("entertainment"))) {
            long anchorUid = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
            UserInfo userInfo = ((IUserCore)ICoreManagerBase.getCore(IUserCore.class)).getCacheUserInfoByUid(anchorUid);
            if (userInfo != null) {
                this.title = userInfo.nickName;
            }
        }
        if (this.mReportPopupDialog == null) {
            this.mReportPopupDialog = new ReportPopupDialog((Context)this.getActivity(), true);
        }
        this.reportReason = "";
        this.mReportPopupDialog.setOnReportItemClickListener(new ReportPopupDialog.OnReportItemClickListener(){

            public void onReportItemClick(int style2, String reason) {
                if (ReportModule.this.getActivity() != null) {
                    Toast.makeText((Context)ReportModule.this.getActivity(), (int)R.string.str_report_success_new, (int)0).show();
                    ReportModule.this.reportReason = reason;
                }
            }
        });
        this.mReportPopupDialog.setBeforeReportListener(new ReportPopupDialog.BeforeReportListener(){

            public boolean beforeReport(int style2) {
                if (6 == style2) {
                    ReportModule.this.sendSoundReportInfo();
                } else {
                    ((IReportCore)CoreFactory.getCore(IReportCore.class)).uploadScreenshot(path, style2, ReportModule.this.title, ReportModule.TAG);
                }
                return false;
            }
        });
        this.mReportPopupDialog.setCancelable(true);
        this.mReportPopupDialog.setCanceledOnTouchOutside(true);
        this.mReportPopupDialog.show();
    }

    public void showFakeReport() {
        if (this.getActivity() == null) {
            Toast.makeText((Context)this.getActivity(), (int)R.string.str_report_fail, (int)0).show();
        }
        if (this.mReportPopupDialog == null) {
            this.mReportPopupDialog = new ReportPopupDialog((Context)this.getActivity());
        }
        if (this.mReportPopupDialog != null) {
            this.mReportPopupDialog.setOnReportItemClickListener(new ReportPopupDialog.OnReportItemClickListener(){

                public void onReportItemClick(int style2, String reason) {
                    Toast.makeText((Context)ReportModule.this.getActivity(), (int)R.string.str_report_success_new, (int)0).show();
                }
            });
            this.mReportPopupDialog.setBeforeReportListener(new ReportPopupDialog.BeforeReportListener(){

                public boolean beforeReport(int style2) {
                    return false;
                }
            });
        }
        this.mReportPopupDialog.setCancelable(true);
        this.mReportPopupDialog.setCanceledOnTouchOutside(true);
        this.mReportPopupDialog.show();
    }

    public void showReport(long reportUid) {
        UserInfo userInfo;
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)("Activity = " + this.getActivity()), (Object[])new Object[0]);
            Toast.makeText((Context)BasicConfig.getInstance().getAppContext(), (int)R.string.str_report_fail, (int)0).show();
            return;
        }
        if (reportUid != 0L && (ICoreManagerBase.getMediaCore().getVideoStreamUid() == reportUid || ICoreManagerBase.getMediaCore().getVideoStreamSecUid() == reportUid)) {
            this.showReport();
            return;
        }
        int type2 = 1;
        int child = 31;
        this.sid = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid;
        this.reportAnchorUid = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
        if (this.title == null && (userInfo = ((IUserCore)ICoreManagerBase.getCore(IUserCore.class)).getCacheUserInfoByUid(LoginUtil.getUid())) != null) {
            this.title = userInfo.nickName;
        }
        this.reportReason = "";
        if (this.userReportPopupDialog == null) {
            this.userReportPopupDialog = new ReportPopupDialog((Context)this.getActivity(), type2, (long)child, reportUid, this.buildReportContent(null), this.buildUserExtParUrlEncoder(reportUid), this.buildExtProductParam(null), null, null, true);
            this.userReportPopupDialog.setOnReportItemClickListener(new ReportPopupDialog.OnReportItemClickListener(){

                public void onReportItemClick(int style2, String reason) {
                    SingleToastUtil.showToast((int)R.string.str_report_success_tip);
                }
            });
        } else {
            this.userReportPopupDialog.setSuid(reportUid);
            this.userReportPopupDialog.setExtParUrlEncoder(this.buildUserExtParUrlEncoder(reportUid));
        }
        this.userReportPopupDialog.setBeforeReportListener(new ReportPopupDialog.BeforeReportListener(){

            public boolean beforeReport(int style2) {
                String videoUrl = SoundReportHelper.Companion.getInstance().getRecordUrl();
                if (6 == style2 && TextUtils.isEmpty((CharSequence)videoUrl)) {
                    Toast.makeText((Context)ReportModule.this.getActivity(), (int)R.string.str_report_success_tip, (int)0).show();
                    return false;
                }
                return true;
            }
        });
        this.initParmRewriteStrategy(this.userReportPopupDialog);
        this.userReportPopupDialog.setCancelable(true);
        this.userReportPopupDialog.setCanceledOnTouchOutside(true);
        this.userReportPopupDialog.show();
    }

    private void initParmRewriteStrategy(ReportPopupDialog dialog) {
        if (dialog != null) {
            dialog.setRewriteParamStrategy(new ReportPopupDialog.ParmRewriteStrategy(){

                public long rewriteChidParm(int style2, long origParm) {
                    if (style2 == 6) {
                        return 18L;
                    }
                    return origParm;
                }

                public String rewriteExtProductorParm(int style2, String origParm) {
                    if (style2 == 6) {
                        String videoUrl = SoundReportHelper.Companion.getInstance().getRecordUrl();
                        return ReportModule.this.buildExtProductParam(videoUrl);
                    }
                    return origParm;
                }

                public int rewriteTypeParm(int style2, int origParm) {
                    if (style2 == 6) {
                        return 2;
                    }
                    return origParm;
                }
            });
        }
    }

    private String buildScreenshotFileName() {
        String fname = "";
        String imei = "";
        if (this.getActivity() != null) {
            imei = CommonUtils.getImei((Context)this.getActivity());
        }
        String timeStamp = System.currentTimeMillis() + "";
        String uid = LoginUtil.getUid() + "";
        fname = imei + "_" + timeStamp + "_" + uid + "_android_mobileyy.jpg";
        return fname;
    }

    public long getOnlineCount() {
        long onlineCount = 0L;
        if (ICoreManagerBase.getCore(IVirtualAudienceCore.class) != null) {
            long mVirtualAudienceNum;
            onlineCount = mVirtualAudienceNum = ((IVirtualAudienceCore)ICoreManagerBase.getCore(IVirtualAudienceCore.class)).getVirtualaudienceCount();
        }
        if (ICoreManagerBase.getChannelLinkCore() != null) {
            long subSid = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid;
            long mOnlineAudienceNum = ICoreManagerBase.getChannelLinkCore().getSubChannelOnlineCount(subSid);
            onlineCount += mOnlineAudienceNum;
        }
        return onlineCount;
    }

    @BusEvent(sync=true)
    public void onReport(IReportClient_onReport_EventArgs busEventArgs) {
        int code = busEventArgs.getCode();
        Map extendInfo = busEventArgs.getData();
        if (extendInfo != null && extendInfo.size() > 0 && extendInfo.containsKey(CONTEXT)) {
            if (code == 0) {
                this.postReportResultInfo(0);
            } else if (code == 1) {
                // empty if block
            }
        } else {
            MLog.info((Object)TAG, (String)("onReport extendInfo =" + extendInfo), (Object[])new Object[0]);
        }
    }

    @BusEvent(sync=true)
    public void onUploadFail(IReportUploadClient_onUploadFail_EventArgs busEventArgs) {
        String context = busEventArgs.getContext();
        if (!StringUtils.isEmptyString((String)context) && context.equals(TAG)) {
            this.postReportResultInfo(1);
        } else {
            MLog.info((Object)TAG, (String)("onUploadFail context = " + context), (Object[])new Object[0]);
        }
    }

    @BusEvent(sync=true)
    public void onUploadSuccess(IReportUploadClient_onUploadSuccess_EventArgs busEventArgs) {
        String url = busEventArgs.getUrl();
        int style2 = busEventArgs.getStyle();
        String title = busEventArgs.getTitle();
        String context = busEventArgs.getContext();
        MLog.info((Object)TAG, (String)("screenShot url = " + url), (Object[])new Object[0]);
        if (!StringUtils.isEmptyString((String)context) && context.equals(TAG)) {
            this.onLiveUploadSuccess(url, style2, title);
        } else {
            MLog.info((Object)TAG, (String)("onUploadSuccess context = " + context), (Object[])new Object[0]);
        }
    }

    protected void onLiveUploadSuccess(String url, int style2, String title) {
        int type2 = 2;
        int child = 18;
        this.sid = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid;
        this.reportAnchorUid = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
        this.title = title;
        String content = this.buildReportContent(url);
        String extParUrlEncoder = this.buildAnchorExtParUrlEncoder();
        String extProductParam = this.buildExtProductParam(url, this.reportReason);
        MLog.info((Object)TAG, (String)("type=" + type2 + "child=" + child + "style=" + style2 + "anchoruid=" + this.reportAnchorUid + "content=" + content + "extParUrlEncoder=" + extParUrlEncoder + "extProductParam" + extProductParam + "title=" + title), (Object[])new Object[0]);
        if (this.reportAnchorUid > 0L) {
            HashMap<String, String> extendInfo = new HashMap<String, String>();
            extendInfo.put(CONTEXT, TAG);
            ((IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class)).sendReportBasic(type2, (long)child, style2, this.reportAnchorUid, content, extParUrlEncoder, extProductParam, extendInfo);
        }
    }

    private void sendSoundReportInfo() {
        String videoUrl = SoundReportHelper.Companion.getInstance().getRecordUrl();
        if (!TextUtils.isEmpty((CharSequence)videoUrl)) {
            int style2 = 6;
            this.onLiveUploadSuccess(videoUrl, style2, this.title);
        } else {
            Toast.makeText((Context)this.getActivity(), (int)R.string.str_report_success_tip, (int)0).show();
        }
    }

    private String generateScreenshotPath() {
        File dir = new File(BasicConfig.getInstance().getRootDir().getAbsolutePath() + "/reported");
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("\u521b\u5efa\u622a\u56fe\u6587\u4ef6\u8def\u5f84\u5931\u8d25");
        }
        this.fileName = "yy_report_" + this.buildScreenshotFileName();
        return dir.getAbsolutePath() + "/" + this.fileName;
    }

    private String saveScreenshot(Bitmap bitmap) {
        this.filePath = this.generateScreenshotPath();
        try {
            Bitmap resizeBitmap = YYImageUtils.resize((Bitmap)bitmap, (float)0.5f);
            if (resizeBitmap != null) {
                YYFileUtils.saveBitmap((Bitmap)resizeBitmap, (String)this.filePath, (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG, (int)80);
            } else {
                MLog.info((Object)TAG, (String)"compress faild resizeBitmap", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)("compress faild " + e.toString()), (Object[])new Object[0]);
        }
        return this.filePath;
    }

    private String buildReportContent(String picUrl) {
        JSONObject jContent = new JSONObject();
        try {
            Date currentDate = new Date();
            SimpleDateFormat formatter = CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm");
            String dateString = formatter.format(currentDate);
            jContent.put("id", (Object)("default_report_" + this.reportAnchorUid + "_" + this.sid));
            jContent.put("title", (Object)this.title);
            jContent.put("type", 4);
            jContent.put("createTime", (Object)dateString);
            JSONArray jcontentArray = new JSONArray();
            JSONObject titleItem = new JSONObject();
            titleItem.put("type", 1);
            titleItem.put("value", (Object)this.title);
            jcontentArray.put((Object)titleItem);
            JSONObject picItem = new JSONObject();
            picItem.put("type", 2);
            picItem.put("value", (Object)picUrl);
            jcontentArray.put((Object)picItem);
            jContent.put("contents", (Object)jcontentArray);
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return jContent.toString();
    }

    private String buildAnchorExtParUrlEncoder() {
        JSONObject jExtParUrlEncoder = new JSONObject();
        try {
            jExtParUrlEncoder.put("uid", this.reportAnchorUid);
            jExtParUrlEncoder.put("sid", this.sid);
            jExtParUrlEncoder.put("appId", 15013);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Empty Catch on buildAnchorExtParUrlEncoder", (Throwable)e);
        }
        return jExtParUrlEncoder.toString();
    }

    private String buildUserExtParUrlEncoder(long reportUid) {
        JSONObject jExtParUrlEncoder = new JSONObject();
        try {
            jExtParUrlEncoder.put("chid", 31);
            jExtParUrlEncoder.put("uid", ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId());
            jExtParUrlEncoder.put("ruid", LoginUtil.getUid());
            jExtParUrlEncoder.put("suid", reportUid);
            jExtParUrlEncoder.put("sid", ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Empty Catch on buildUserExtParUrlEncoder", (Throwable)e);
        }
        return jExtParUrlEncoder.toString();
    }

    private String buildExtProductParam(String picUrl, String reportReason) {
        JSONObject jExtProductParam = new JSONObject();
        try {
            jExtProductParam.put("submitPhoneNum", (Object)"");
            jExtProductParam.put("reportedLocation", (Object)"");
            jExtProductParam.put("reportedPhoneNum", (Object)"");
            jExtProductParam.put("extraData", (Object)reportReason);
            long streamId = 0L;
            int appId = 15013;
            JSONArray jcontentArray = new JSONArray();
            if (ICoreManagerBase.getMediaCore() != null) {
                streamId = ICoreManagerBase.getMediaCore().getVideoStreamId();
                long anchorUid = ICoreManagerBase.getMediaCore().getVideoStreamUid();
                long secondUid = ICoreManagerBase.getMediaCore().getVideoStreamSecUid();
                JSONObject anchorUidObj = new JSONObject();
                anchorUidObj.put("uid", anchorUid);
                jcontentArray.put((Object)anchorUidObj);
                JSONObject secondUidObj = new JSONObject();
                secondUidObj.put("uid", secondUid);
                jcontentArray.put((Object)secondUidObj);
                appId = ICoreManagerBase.getMediaCore().getVideoAppId();
                if (appId == 0) {
                    appId = 15013;
                }
            }
            jExtProductParam.put("lianmaiUid", (Object)jcontentArray);
            long subSid = 0L;
            if (ICoreManagerBase.getChannelLinkCore() != null && ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo() != null) {
                subSid = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid;
            }
            jExtProductParam.put("reportedSid", this.sid);
            jExtProductParam.put("reportedSsid", subSid);
            jExtProductParam.put("reportedVideoId", streamId);
            jExtProductParam.put("reportedVideoAppid", appId);
            jExtProductParam.put("reportedVideoTitle", (Object)this.title);
            jExtProductParam.put("reportedVideoOnlineNum", this.getOnlineCount());
            JSONArray reportedCaptureUrlArray = new JSONArray();
            JSONObject reportedCaptureUrl = new JSONObject();
            reportedCaptureUrl.put("url", (Object)picUrl);
            reportedCaptureUrlArray.put((Object)reportedCaptureUrl);
            jExtProductParam.put("reportedCaptureUrl", (Object)reportedCaptureUrlArray);
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return jExtProductParam.toString();
    }

    private String buildExtProductParam(String picUrl) {
        JSONObject jExtProductParam = new JSONObject();
        try {
            jExtProductParam.put("submitPhoneNum", (Object)"");
            jExtProductParam.put("reportedLocation", (Object)"");
            jExtProductParam.put("reportedPhoneNum", (Object)"");
            long streamId = 0L;
            int appId = 15013;
            JSONArray jcontentArray = new JSONArray();
            if (ICoreManagerBase.getMediaCore() != null) {
                streamId = ICoreManagerBase.getMediaCore().getVideoStreamId();
                long anchorUid = ICoreManagerBase.getMediaCore().getVideoStreamUid();
                long secondUid = ICoreManagerBase.getMediaCore().getVideoStreamSecUid();
                JSONObject anchorUidObj = new JSONObject();
                anchorUidObj.put("uid", anchorUid);
                jcontentArray.put((Object)anchorUidObj);
                JSONObject secondUidObj = new JSONObject();
                secondUidObj.put("uid", secondUid);
                jcontentArray.put((Object)secondUidObj);
                appId = ICoreManagerBase.getMediaCore().getVideoAppId();
                if (appId == 0) {
                    appId = 15013;
                }
            }
            jExtProductParam.put("lianmaiUid", (Object)jcontentArray);
            long subSid = 0L;
            if (ICoreManagerBase.getChannelLinkCore() != null && ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo() != null) {
                subSid = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid;
            }
            jExtProductParam.put("reportedSid", this.sid);
            jExtProductParam.put("reportedSsid", subSid);
            jExtProductParam.put("reportedVideoId", streamId);
            jExtProductParam.put("reportedVideoAppid", appId);
            jExtProductParam.put("reportedVideoTitle", (Object)this.title);
            jExtProductParam.put("reportedVideoOnlineNum", this.getOnlineCount());
            JSONArray reportedCaptureUrlArray = new JSONArray();
            JSONObject reportedCaptureUrl = new JSONObject();
            reportedCaptureUrl.put("url", (Object)picUrl);
            reportedCaptureUrlArray.put((Object)reportedCaptureUrl);
            jExtProductParam.put("reportedCaptureUrl", (Object)reportedCaptureUrlArray);
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return jExtProductParam.toString();
    }

    public void postReportResultInfo(int result) {
        long uid = LoginUtil.getUid();
        if (this.reportAnchorUid <= 0L || uid <= 0L || StringUtils.isEmpty((String)this.fileName).booleanValue()) {
            return;
        }
        RequestParam requestParam = CommonParamUtil.fillCommonParam();
        requestParam.put("uri", "UploadScreenshot");
        if (result == 0) {
            requestParam.put("code", "0");
        } else {
            requestParam.put("code", "1");
        }
        requestParam.put("uid", String.valueOf(uid));
        requestParam.put("pUid", String.valueOf(this.reportAnchorUid));
        requestParam.put("topSid", ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid + "");
        requestParam.put("subSid", ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid + "");
        requestParam.put("fileName", this.fileName);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("requestParam = " + requestParam), (Object[])new Object[0]);
        }
        RequestManager.instance().submitStringQueryRequest(LinkUriProvider.REPORT_RESULT_STATISTIC, requestParam, (ResponseListener)new ResponseListener<String>(){

            public void onResponse(String response) {
                MLog.info((Object)ReportModule.TAG, (String)"report success", (Object[])new Object[0]);
            }
        }, new ResponseErrorListener(){

            public void onErrorResponse(RequestError error) {
                MLog.info((Object)ReportModule.TAG, (String)"report failed", (Object[])new Object[0]);
            }
        }, false);
    }

    public void destroy() {
        MLog.verbose((Object)TAG, (String)"destroy!!!", (Object[])new Object[0]);
        super.destroy();
        if (this.mReportPopupDialog != null) {
            this.mReportPopupDialog = null;
        }
    }
}

