/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.pknor.ui.circleProgressView;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.yy.mobile.plugin.pluginunionchannelpk.R;

public class CircleOutCoverView
extends View {
    Context mContex;
    Paint mCirclePaint;
    Paint mCirclePaintOut;
    int mWidth;
    int mHeight;
    float radius = 0.0f;
    float currentRadius = 0.0f;
    boolean isStopAnimation = false;

    public CircleOutCoverView(Context context) {
        super(context);
        this.mContex = context;
        this.initView();
    }

    public CircleOutCoverView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mContex = context;
        this.initView();
    }

    private void initView() {
        this.mCirclePaint = new Paint();
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setStyle(Paint.Style.FILL);
        this.mCirclePaint.setColor(ContextCompat.getColor((Context)this.mContex, (int)R.color.red));
        this.mCirclePaint.setAlpha(50);
        this.mCirclePaintOut = new Paint();
        this.mCirclePaintOut.setAntiAlias(true);
        this.mCirclePaintOut.setStyle(Paint.Style.STROKE);
        this.mCirclePaintOut.setStrokeWidth((float)this.dp2px(this.mContex, 2.0f));
        this.mCirclePaintOut.setColor(ContextCompat.getColor((Context)this.mContex, (int)R.color.red));
        this.mCirclePaintOut.setAlpha(60);
        this.playAnimaton();
    }

    private void playAnimaton() {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.9f, 1.3f});
        animator.setDuration(500L);
        animator.setStartDelay(300L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                CircleOutCoverView.this.currentRadius = CircleOutCoverView.this.radius * value;
                CircleOutCoverView.this.invalidate();
            }
        });
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                CircleOutCoverView.this.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                CircleOutCoverView.this.setVisibility(8);
                if (!CircleOutCoverView.this.isStopAnimation) {
                    CircleOutCoverView.this.playAnimaton();
                } else {
                    CircleOutCoverView.this.isStopAnimation = false;
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animator.start();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = this.getMeasuredWidth();
        this.mHeight = this.getMeasuredHeight();
        this.radius = (this.mWidth > this.mHeight ? this.mHeight : this.mWidth) / 2;
    }

    protected void onDraw(Canvas canvas) {
        float halfWidth = this.mWidth / 2;
        float halfHeight = this.mHeight / 2;
        canvas.drawCircle(halfWidth, halfHeight, this.currentRadius, this.mCirclePaint);
        canvas.drawCircle(halfWidth, halfHeight, this.currentRadius + (float)(this.dp2px(this.mContex, 2.0f) / 2), this.mCirclePaintOut);
    }

    public int dp2px(Context context, float dpVal) {
        return (int)TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public void stopAnimation() {
        this.isStopAnimation = true;
    }
}

