/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.pkrank.ui;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.yy.mobile.channelpk.coremodule.M_Two;
import com.yy.mobile.channelpk.ui.pkrank.utils.RankLevelUtils;
import com.yy.mobile.memoryrecycle.drawablerecycle.DrawableUtil;
import com.yy.mobile.plugin.pluginunionchannelpk.R;

public class RankLevelView
extends LinearLayout {
    private View rootView;
    private Context mContext;
    private ImageView ivRankLevelNum;
    private ImageView ivRankLevel;
    private LayoutInflater mLayoutInflater;
    private int division;
    private int phase;

    public RankLevelView(Context context) {
        this(context, null);
    }

    public RankLevelView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RankLevelView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        this.initRootView();
        this.initView();
    }

    private void initRootView() {
        this.rootView = this.mLayoutInflater.inflate(R.layout.view_pk_rank_level, null);
        this.addView(this.rootView);
    }

    private void initView() {
        this.ivRankLevelNum = (ImageView)this.rootView.findViewById(R.id.iv_rank_level_num);
        this.ivRankLevel = (ImageView)this.rootView.findViewById(R.id.iv_rank_level);
    }

    private void createRankLevelView(int resId) {
        if (this.division == -1 || this.phase == -1) {
            this.rootView.setVisibility(4);
            return;
        }
        this.rootView.setVisibility(0);
        this.ivRankLevel.setBackgroundResource(resId);
        if (this.phase >= 1 && this.phase <= 4) {
            this.ivRankLevelNum.setVisibility(0);
            this.ivRankLevelNum.setImageDrawable(DrawableUtil.getDrawable((int)RankLevelUtils.getRankLevelNumberResId(this.phase)));
        } else {
            this.ivRankLevelNum.setVisibility(4);
        }
    }

    public void setRankLevelData(int division, int phase) {
        this.division = division;
        this.phase = phase;
        if (M_Two.isRevengeForDialog()) {
            this.createRankLevelView(RankLevelUtils.getRevengeLevelResId(division));
        } else {
            this.createRankLevelView(RankLevelUtils.getRankLevelResId(division));
        }
    }

    public void setRevengeOrRankLevelDataForLeftSize(int division, int phase) {
        this.division = division;
        this.phase = phase;
        if (M_Two.isRevengeForPkBarInLeftSize()) {
            this.createRankLevelView(RankLevelUtils.getRevengeLevelResId(division));
        } else {
            this.createRankLevelView(RankLevelUtils.getRankLevelResId(division));
        }
    }

    public void setRevengeOrRankLevelDataForRightSize(int division, int phase) {
        this.division = division;
        this.phase = phase;
        if (M_Two.isRevengeForPkBarInRightSize()) {
            this.createRankLevelView(RankLevelUtils.getRevengeLevelResId(division));
        } else {
            this.createRankLevelView(RankLevelUtils.getRankLevelResId(division));
        }
    }
}

