package com.yy.mobile.oppo

import android.annotation.TargetApi
import android.os.Build
import android.util.Log
import java.lang.reflect.InvocationHandler
import java.lang.reflect.Method

/**
 * Created by wangfeihang on 2019-06-19.
 *
 * 代理realobj方法的执行
 * 可设置[beforeInvoke],在realobj执行前执行
 * [changeArgs],在realobj执行前执行,替换realobj执行时的参数
 * [afterInvoke],在realobj执行后执行,可替换realobj执行后的返回值
 *
 */
class ApiInvocationHandler(
    var realObj: () -> Any?,
    var beforeInvoke: BeforeInvokeFun? = null,
    var changeArgs: ChangeArgsFun? = null,
    var afterInvoke: AfterInvokeFun? = null
) : InvocationHandler {

    override fun invoke(proxy: Any?, method: Method?, args: Array<out Any>?): Any? {

        fun breakBeforeFun(): Boolean {
            return beforeInvoke?.let {
                it(method, args)
            } ?: false
        }

        @TargetApi(Build.VERSION_CODES.O)
        fun objInvoke(): Any? {
            Log.i("ApiInvocationHandler", "objInvoke")
            val changedArgs = changeArgs?.let { it(method, args) }

            val realObject = realObj()
            Log.i("ApiInvocationHandler", "args:size:${args?.size}")
            args?.forEach {
                Log.i("ApiInvocationHandler", "args:${it.toString()}")
            }
            val passArgs = changedArgs ?: args
            return when {
                realObject == null -> null
                passArgs == null -> method?.invoke(realObject)
                else -> method?.invoke(realObject, *passArgs)
            }
        }

        fun afterFun(realResult: Any?): Any? {
            var invokeResult: Any? = null
            if (afterInvoke != null) {
                afterInvoke?.let {
                    invokeResult = it(method, args, realResult)
                }
            }

            return invokeResult ?: realResult
        }

        if (!breakBeforeFun()) {
            val realResult = objInvoke()
            return afterFun(realResult)
        }
        return null

    }
}

typealias BeforeInvokeFun = (method: Method?, args: Array<out Any>?) -> Boolean

typealias ChangeArgsFun = (method: Method?, args: Array<out Any>?) -> Array<out Any>?

typealias AfterInvokeFun = (method: Method?, args: Array<out Any>?, realResult: Any?) -> Any?