package com.yy.mobile.oppo

import android.app.Activity
import android.app.Application
import android.app.Dialog
import android.app.ProgressDialog
import android.content.Context
import android.util.Log
import com.yy.android.small.pluginbase.IPluginEntryPoint
import com.yy.mobile.bizmodel.login.LoginUtil
import com.yy.mobile.replugin.ApiBridge
import com.yy.mobile.unionsdk.FinishListener
import com.yy.mobile.unionsdk.UnionYYSdk
import com.yy.mobile.util.DontProguardClass
import com.yy.mobile.util.DontProguardMethod
import com.yy.mobile.util.log.MLog
import java.lang.reflect.Proxy

/**
 * Created by wangfeihang on 2019-06-19.
 */
@DontProguardClass
object OPPOYYSDK : UnionYYSdk() {

    private const val TAG = "OPPOYYSDK"

    /**
     * OPPO获取我方实现的方法。
     * 调用该方法后，如果yy的sdk还没有被初始化，会先进行sdk的初始化，然后再执行接口内的业务逻辑
     * [actionCls] 双方定义的接口类的class
     * [application] 美拍application，用来进行sdk的初始化
     * [context] 美拍传进来的当前context，用来show sdk加载时的loading弹窗
     */
    fun <Action : Any> obtainAction(
        actionCls: Class<Action>,
        application: Application,
        context: Context
    ): Action? {
        if (isInstalling.get()) {
            Log.e(TAG, "sdk is isInstalling")
            return null
        }

        val invocationHandler = ApiInvocationHandler(
            realObj = { ApiBridge.getApi(actionCls) },
            beforeInvoke = { _, _ ->
                //                val loadingDialog = showSDKLoadingDialog(context)

                val initSuccess = initYYSdkSuc(application, object : FinishListener {
                    override fun onFinish() {
//                        loadingDialog?.dismiss()
                        MLog.info(TAG, "dialog dismiss")
                    }
                })

                if (initSuccess) {
                    LoginUtil.synchronizeUnionLoginState()
                }

                !initSuccess
            }
        )
        return Proxy.newProxyInstance(
            invocationHandler.javaClass.classLoader,
            arrayOf(actionCls),
            invocationHandler
        ) as Action
    }

    private fun showSDKLoadingDialog(context: Context): Dialog? {
        if (context is Activity && !context.isFinishing) {
            val progressDialog = ProgressDialog(context).apply {
                //                this.setMessage("正在加载中...")
                this.setCancelable(false)
            }
            progressDialog.show()
            MLog.info(TAG, "dialog showing")
            return progressDialog
        }
        return null
    }

    /**
     * This method will be invoked by inflection. (Magnet/RestartUnionSDK)
     */
    @JvmStatic
    @JvmOverloads
    @DontProguardMethod
    fun initYYSdk(application: Application, finishListener: FinishListener? = null) {
        initYYSdkSuc(application, object : FinishListener {
            override fun onFinish() {
                MLog.info(TAG, "initYYSdk, onFinish")
                finishListener?.onFinish()
            }
        })
    }

    override fun initYYSdkSuc(application: Application, finishListener: FinishListener): Boolean {
        MLog.info(TAG, "initYYSdk")
        if (isInstalling.get()) {
            this.addFinishListener(finishListener)
        } else if (!isInstalled.get()) {
            MLog.info(TAG, "not isInstalled")
            this.init(application, true)
            this.initAsync {
                finishListener.onFinish()
            }
            return true
        } else {
            finishListener.onFinish()
            return true
        }
        return false
    }

    override fun dealWithSvcState(pluginMap: Map<String, Pair<Set<String>?, IPluginEntryPoint>>) {
        finish(pluginMap.keys.toList())
    }
}

