package com.unionyy.mobile.oppo.api

import android.content.Context

/**
 * 实名认证接口
 */
interface YY2OPVerifiedAction {

    /**
     * 调用OPPO实名认证的页面
     *
     * @param callback 可选，实名认证后的回调。接受部分平台没有回调。
     */
    fun showVerifiedActivity(context: Context, callback: YYVerifiedCallback?)

    /**
     * 获得当前账号实名状态
     */
    fun isVerifiedAccount(): Boolean
}

interface YYVerifiedCallback {

    /**
     * 认证成功后通知给YY
     */
    fun onSucess() {}

    /**
     * 取消认证后通知给YY
     */
    fun onCancel() {}

    /**
     * 认证失败后通知给YY
     */
    fun onFail() {}
}