package com.unionyy.mobile.oppo.api

import android.app.Activity
import java.lang.ref.WeakReference

/**
 * YY调用，OPPO实现
 * 用户信息相关接口
 *
 * Created by liyang on 2020-02-06
 * email: liyang4@yy.com
 */
interface YY2OPUserInfoAction {

    companion object {
        const val YY_UID = "yyUid"// YY用户id
        const val NICK = "nick"// 用户昵称
        const val AVATAR = "avatar"// 用户头像
    }

    /**
     * 查询当前登录用户信息
     *
     * @return oppo用户信息map
     */
    fun getUserInfo(callback: WeakReference<UserInfoCallback>)

    /**
     * 查询用户是否已修改信息
     */
    fun queryUserModifiedInfo(callback: QueryUserModifiedCallback)

    /**
     * 显示修改信息弹窗
     */
    fun showModifyInfoDialog(activity: Activity, callback: ModifyInfoCallback)
}

interface UserInfoCallback {

    /**
     * 返回oppo用户信息
     */
    fun onGetUserInfo(infoMap: Map<String, String>)
}

interface QueryUserModifiedCallback {

    /**
     * 返回查询用户是否修改信息结果
     *
     * @param hasModified true：已修改，不弹窗，false：未修改，需要弹窗
     */
    fun onQueryResult(hasModified: Boolean)
}

interface ModifyInfoCallback {

    /**
     * 返回修改结果
     *
     * @param hasModified true：已修改，false：未修改
     */
    fun onModifyResult(hasModified: Boolean)
}