package com.unionyy.mobile.oppo.api

import java.lang.ref.WeakReference

/**
 * 关注相关接口
 * OPPO实现，YY调用
 *
 * Created by liyang on 2020-02-14
 * email: liyang4@yy.com
 */
interface YY2OPSubscribeAction {

    /**
     * 关注/取消关注
     *
     * @param intention 意图 1：关注，-1：取消关注
     * @param anchorId 主播id
     * @param extendInfo 主播信息json字符串，包括anchorName、anchorSex（男/女）、anchorAvatar
     */
    fun requestSubscribe(
        intention: Byte,
        anchorId: String,
        extendInfo: String,
        callback: WeakReference<OppoSubscribeCallback>
    )

    /**
     * 查询关注状态
     *
     * @param anchorId 主播id集合，以","分隔，最多100个
     */
    fun querySubscribeStatus(anchorId: String, callback: WeakReference<OppoSubscribeStatusCallback>)
}

interface OppoSubscribeCallback {

    /**
     * 关注回调接口
     *
     * @param success 关注/取消关注结果
     */
    fun onResult(success: Boolean)
}

interface OppoSubscribeStatusCallback {

    /**
     * 关注状态回调接口
     *
     * @param statusMap 关注状态map：key -> 主播id，value -> 关注状态
     */
    fun onResult(statusMap: Map<String, Boolean>)
}