package com.unionyy.mobile.oppo.api

import android.content.Context
import com.yy.mobile.baseapi.YY2UnionLoginAction

/**
 * 登录相关接口
 * OPPO实现，YY调用
 *
 * Created by liyang on 2020-01-19
 * email: liyang4@yy.com
 */
interface YY2OPLoginAction : YY2UnionLoginAction {

    /**
     * 拉起OPPO登录弹窗
     */
    override fun showLoginDialog(context: Context)

    /**
     * 获取accessToken，未登录返回null
     */
    fun getOpenAccessToken(context: Context, callback: OpenThirdPartyInfoCallback)

    /**
     * 获取accessCode，未登录返回null
     */
    fun getOpenAccessCode(context: Context, callback: OpenThirdPartyInfoCallback)

    /**
     * OPPO账号是否登录
     */
    fun isOppoLogined(): Boolean

    /**
     * 使用OPPO提供的accessCode登录后，返回uid和ticket，用于绑定YY账号和OPPO账号
     * 可选项
     */
    fun bindAfterLogin(uid: Long, ticket: String) {}
}

interface OpenThirdPartyInfoCallback {

    fun onResult(info: String?)

    fun onFail(e: Exception)
}