package com.unionyy.mobile.oppo.api

import android.content.Context

/**
 * OPPO调用，YY实现
 * 回放页相关action
 *
 * Created by liyang on 2020-02-04
 * email: liyang4@yy.com
 */
interface OP2YYReplayAction {

    /**
     * 进入回放页
     *
     * @param replayId 录播id
     * @param uid 主播uid
     * @param playUrl 回放地址
     * @param imgUrl 回放封面地址
     * @param title 回放标题
     * @param toMobileLiveReplayPath MobileLiveCoreImpl中有统计
     */
    fun startReplayLiveActivity(
        context: Context,
        replayId: String,
        uid: Long,
        playUrl: String,
        imgUrl: String,
        title: String,
        toMobileLiveReplayPath: Int
    )
}