package com.unionyy.mobile.oppo.api

import com.yy.mobile.baseapi.AuthCallback
import com.yy.mobile.baseapi.Union2YYAuthAction

/**
 * 登录相关接口
 * YY实现，OPPO调用
 *
 * Created by liyang on 2020-01-19
 * email: liyang4@yy.com
 */
interface OP2YYAuthAction : Union2YYAuthAction {

    /**
     * OPPO账号绑定YY账号登录
     * 用户已经登录OPPO账号时调用
     *
     * @param accessCode OPPO授权凭证
     * @param callback 登录结果回调
     */
    fun bindLogin(accessCode: String, callback: AuthCallback)

    /**
     * 当前YY账号是否登录
     */
    override fun isYYLogined(): Boolean

    /**
     * 如果YY账号一登录，可获得YY账号对应的uid，否则返回null
     */
    override fun getCurrentYYId(): Long?

    /**
     * 退出YY登录
     */
    override fun logout()
}
