package com.unionyy.mobile.oppo.api

import android.content.Context
import com.yy.mobile.baseapi.YY2OPQueryBalanceCallBack
import com.yy.mobile.baseapi.YY2UnionRechargeAction
import com.yy.mobile.baseapi.YYRechargeCallBack
import java.lang.ref.WeakReference

/**

 * @Author weidong_wu

 * @Date 2020-02-12-11:55

 * @Email wuweidong@yy.com

 * @Note
 */
interface YY2OPRechargeAction : YY2UnionRechargeAction {

    /**
     * 支付接口
     * @param price 充值金额 可不传
     * @param number 商品数量 可不传
     * @param productName 商品名称 可不传
     * @param productDesc 商品描述 可不传
     * @param callbackRef 充值回调
     */
    fun toOPPay(context: Context,
                price: Int, number: Int,
                productName: String,
                productDesc: String,
                callbackRef: WeakReference<YYRechargeCallBack>?)

    /**
     * 查询余额接口
     *
     */
    fun queryBalances(callbackRef: WeakReference<YY2OPQueryBalanceCallBack>?)

}

