/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.basemedia.watchlive.template;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import android.view.animation.Animation;
import com.duowan.mobile.basemedia.api.template.DLPresenterFactory;
import com.duowan.mobile.basemedia.watchlive.template.AbstractComponentContainer$$EventBinder;
import com.duowan.mobile.basemedia.watchlive.template.ContainerMvpInnerDelegate;
import com.duowan.mobile.basemedia.watchlive.template.ContainerMvpPresenter;
import com.duowan.mobile.basemedia.watchlive.template.DLContainerMvpPresenter;
import com.duowan.mobile.basemedia.watchlive.template.generate.ComponentWrapper;
import com.duowan.mobile.basemedia.watchlive.template.generate.ComponentsMaker;
import com.duowan.mobile.basemedia.watchlive.template.generate.TrunkContainerConfig;
import com.duowan.mobile.entlive.events.ILiveComponentClient_onAddComponent_EventArgs;
import com.duowan.mobile.entlive.events.ILiveComponentClient_onHideComponent_EventArgs;
import com.duowan.mobile.entlive.events.ILiveComponentClient_onRemoveComponent_EventArgs;
import com.duowan.mobile.entlive.events.ILiveComponentClient_onSetComponentVisibility_EventArgs;
import com.duowan.mobile.entlive.events.ILiveComponentClient_onShowComponent_EventArgs;
import com.duowan.mobile.entlive.events.ILiveComponentClient_onShowPopupComponent_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.mvp.MvpInnerDelegate;
import com.yy.mobile.mvp.MvpInnerDelegateCallback;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponent;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponentContainer;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponentRoot;
import com.yy.mobile.ui.basicchanneltemplate.component.IPopupComponent;
import com.yy.mobile.ui.basicchanneltemplate.component.PopupComponent;
import com.yy.mobile.ui.basicfunction.ScreenRotationUtils;
import com.yy.mobile.util.exception.ExceptionUtil;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractComponentContainer
extends Component<ContainerMvpPresenter<AbstractComponentContainer>, AbstractComponentContainer>
implements IComponentContainer {
    private static final String TAG = "AbstractComponentContainer";
    SparseArray<Set<IComponent>> mInitComponents = new SparseArray();
    List<Integer> mLevelList = new ArrayList<Integer>();
    Class<? extends TrunkContainerConfig> mConfig;
    TrunkContainerConfig mConfigInstance;
    TrunkContainerConfig mBaseConfigInstance;
    ComponentsMaker mComponentMaker;
    HashMap<Class<? extends IComponent>, IComponent> mChildren = new HashMap();
    boolean isInitStart;
    int[] transitionAnimation = new int[2];
    int transit;
    private EventBinder mAbstractComponentContainerSniperEventBinder;

    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        Animation animation = null;
        if (this.mConfigInstance != null) {
            animation = this.mConfigInstance.onCreateAnimation(transit, enter);
        }
        if (animation != null && enter) {
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        }
        return animation;
    }

    protected MvpInnerDelegate<ContainerMvpPresenter<AbstractComponentContainer>, AbstractComponentContainer> onCreateDelegate() {
        return new ContainerMvpInnerDelegate<ContainerMvpPresenter<AbstractComponentContainer>, AbstractComponentContainer>((MvpInnerDelegateCallback<ContainerMvpPresenter<AbstractComponentContainer>, AbstractComponentContainer>)this);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        if (this.mAbstractComponentContainerSniperEventBinder == null) {
            this.mAbstractComponentContainerSniperEventBinder = new AbstractComponentContainer$$EventBinder();
        }
        this.mAbstractComponentContainerSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, savedInstanceState);
        this.peekAndAttachComponents();
        ((ContainerMvpPresenter)this.mPresenter).onViewCreated(view, savedInstanceState);
    }

    public void onDestroyView() {
        super.onDestroyView();
        ((ContainerMvpPresenter)this.mPresenter).onDestroyView();
        Object var2_1 = null;
        if (this.mAbstractComponentContainerSniperEventBinder != null) {
            this.mAbstractComponentContainerSniperEventBinder.unBindEvent();
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (this.mPresenter != null) {
            ((ContainerMvpPresenter)this.mPresenter).onAttach(activity);
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.isInitStart = true;
        this.onContainerInit();
        this.prepareComponentsFromConfig();
    }

    public void onDetach() {
        super.onDetach();
        if (this.mPresenter != null) {
            ((ContainerMvpPresenter)this.mPresenter).onDetach();
        }
    }

    public void onContainerInit() {
        if (this.mConfigInstance != null) {
            this.mConfigInstance.onContainerInit(this.getArguments());
        }
    }

    public void onResume() {
        super.onResume();
        this.setupOrientation((Activity)this.getActivity());
    }

    public void setupOrientation(Activity activity) {
        if (this.mConfigInstance != null) {
            if (this.mConfigInstance.getOrientationWhenAsRoot() == 1) {
                ScreenRotationUtils.setScreenPortrait(activity);
            } else if (this.mConfigInstance.getOrientationWhenAsRoot() == 2) {
                ScreenRotationUtils.setScreenLandscape(activity);
            }
        }
    }

    public void onContainerDestroy() {
        this.isInitStart = false;
        this.detachAllComponent();
        if (this.mConfigInstance != null) {
            this.mConfigInstance.onContainerUninit();
        }
        ((ContainerMvpPresenter)this.mPresenter).onContainerDestroy();
    }

    public void onContainerInitDone() {
        MLog.info((Object)TAG, (String)"All Done", (Object[])new Object[0]);
        if (this.mConfigInstance != null && this.isInitStart) {
            this.mConfigInstance.onInitDone();
            this.getRoot().onContainerApplyDone();
            ((ContainerMvpPresenter)this.mPresenter).onContainerInitDone();
            this.isInitStart = false;
        }
    }

    public boolean onBackPressed() {
        return super.onBackPressed() || ((ContainerMvpPresenter)this.mPresenter).onBackPressed();
    }

    public void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        ((ContainerMvpPresenter)this.mPresenter).onOrientationChanged(isLandscape);
    }

    private void prepareComponentsFromConfig() {
        if (this.mConfig == null) {
            return;
        }
        List<Class<? extends IComponent>> list = this.mComponentMaker.configOf(this.mConfig);
        MLog.info((Object)TAG, (String)("prepareComponentsFromConfig:" + this.mConfig.getSimpleName() + " mConfigInstance:" + this.mConfigInstance), (Object[])new Object[0]);
        HashMap<Class<? extends IComponent>, IComponent> lastExistChildren = new HashMap<Class<? extends IComponent>, IComponent>(this.mChildren);
        for (Class<? extends IComponent> clz : list) {
            if (!lastExistChildren.isEmpty() && lastExistChildren.containsKey(clz)) continue;
            ComponentWrapper<? extends IComponent> wrapper = this.mComponentMaker.wrapper(clz);
            Bundle baseBundle = wrapper.initBundle(this.mBaseConfigInstance);
            Bundle bundle = wrapper.initBundle(this.mConfigInstance);
            bundle.putAll(baseBundle);
            IComponent component = this.mComponentMaker.of(clz, bundle);
            LinkedHashSet<IComponent> sameLevelList = (LinkedHashSet<IComponent>)this.mInitComponents.get(wrapper.initLevel(this.mConfig));
            if (sameLevelList == null) {
                sameLevelList = new LinkedHashSet<IComponent>();
                this.mLevelList.add(wrapper.initLevel(this.mConfig));
            }
            sameLevelList.add(component);
            this.mInitComponents.put(wrapper.initLevel(this.mConfig), sameLevelList);
            component.setTemplate(this.getRoot());
            component.setParent((IComponentContainer)this);
            if (component instanceof AbstractComponentContainer) {
                AbstractComponentContainer container = (AbstractComponentContainer)component;
                container.setup(this.mComponentMaker);
            }
            this.mChildren.put(component.getClass(), component);
        }
        Collections.sort(this.mLevelList, new Comparator<Integer>(){

            @Override
            public int compare(Integer integer, Integer t1) {
                return integer.compareTo(t1);
            }
        });
    }

    private void peekAndAttachComponents() {
        Set<IComponent> list = this.peekInitComponents();
        if (list != null) {
            this.initComponents(list);
        } else {
            this.onContainerInitDone();
        }
    }

    public void onComponentLoad(IComponent component) {
        MLog.info((Object)TAG, (String)("Done:" + component.getClass().getSimpleName()), (Object[])new Object[0]);
        if (this.mLevelList.isEmpty()) {
            this.onContainerInitDone();
        } else {
            int level = this.mLevelList.get(0);
            Set initingComponent = (Set)this.mInitComponents.get(level);
            initingComponent.remove(component);
            if (initingComponent.isEmpty()) {
                this.mLevelList.remove(0);
                this.mInitComponents.remove(level);
                this.peekAndAttachComponents();
            }
        }
    }

    private Set<IComponent> peekInitComponents() {
        Set ret = null;
        if (!this.mLevelList.isEmpty()) {
            int level = this.mLevelList.get(0);
            ret = (Set)this.mInitComponents.get(level);
        }
        return ret;
    }

    public void setTemplate(IComponentRoot root) {
        super.setTemplate(root);
        this.setChildrenTemplate(root);
    }

    private void setChildrenTemplate(IComponentRoot template) {
        Collection<IComponent> list = this.mChildren.values();
        for (IComponent iComponent : list) {
            iComponent.setTemplate(template);
        }
    }

    public void setup(ComponentsMaker maker) {
        this.mComponentMaker = maker;
        this.setupInner(maker);
    }

    private void setupInner(ComponentsMaker maker) {
        if (maker != null) {
            this.mConfigInstance = maker.getConfig(((Object)((Object)this)).getClass());
            this.mBaseConfigInstance = maker.getBaseConfig(((Object)((Object)this)).getClass());
            if (this.mConfigInstance != null) {
                this.mConfig = this.mConfigInstance.getRootConfigClz();
                DLPresenterFactory presenterFactory = this.mConfigInstance.getDLContainerPresenter();
                DLContainerMvpPresenter presenter = null;
                if (presenterFactory != null) {
                    try {
                        presenter = presenterFactory.create((ContainerMvpPresenter)this.getPresenter());
                    }
                    catch (Throwable e) {
                        ExceptionUtil.throwOrWriteLog((String)TAG, (Object[])new Object[]{e});
                    }
                }
                if (!(presenter == null || this.mPresenter != null && ((ContainerMvpPresenter)this.mPresenter).containOrEquals(((Object)((Object)presenter)).getClass()))) {
                    this.setPresenter(presenter);
                }
            }
        }
        if (this.mPresenter == null) {
            this.setPresenter(new ContainerMvpPresenter());
        }
    }

    public void reload() {
        if (this.mComponentMaker == null) {
            throw new IllegalStateException("plz invoke setup(ComponentsMaker maker) method first.");
        }
        this.isInitStart = true;
        this.setupInner(this.mComponentMaker);
        this.onContainerInit();
        this.prepareComponentsFromConfig();
        this.peekAndAttachComponents();
    }

    public List<IComponent> getIncludeComponents() {
        ArrayList<IComponent> list = new ArrayList<IComponent>();
        list.add((IComponent)this);
        list.addAll(this.mChildren.values());
        return list;
    }

    public void initComponents(Set<IComponent> components) {
        if (components != null && components.size() > 0) {
            ArrayList<IComponent> clone = new ArrayList<IComponent>(components);
            this.commitComponents(clone);
        }
    }

    private void commitComponents(ArrayList<IComponent> components) {
        FragmentManager fm = this.getChildFragmentManager();
        FragmentTransaction ft = fm.beginTransaction();
        for (IComponent component : components) {
            int resId = this.mComponentMaker.wrapper(component.getClass()).resourceId(this.mConfig);
            this.commitComponents(resId, component, ft);
        }
        ft.commitAllowingStateLoss();
    }

    private void commitComponents(int componentId, IComponent component, FragmentTransaction ft) {
        String tag = component.getClass().getSimpleName() + "_" + componentId;
        Fragment fragment = component.getContent();
        MLog.info((Object)TAG, (String)("componentsCommits tag=" + tag + ", isAdded=" + fragment.isAdded() + ", isDetached=" + fragment.isDetached() + ", isHidden=" + fragment.isHidden() + ", isInLayout=" + fragment.isInLayout()), (Object[])new Object[0]);
        if (component.isInitHidden()) {
            if (componentId >>> 24 != 0) {
                MLog.info((Object)TAG, (String)("commitComponents detach:" + component.getClass().getSimpleName()), (Object[])new Object[0]);
                ft.detach(fragment).add(componentId, fragment, component.getClass().getSimpleName());
            } else {
                MLog.info((Object)TAG, (String)("commitComponents ignore:" + component.getClass().getSimpleName()), (Object[])new Object[0]);
                this.onComponentLoad(component);
            }
        } else {
            MLog.info((Object)TAG, (String)("commitComponents replace:" + component.getClass().getSimpleName()), (Object[])new Object[0]);
            ft.replace(componentId, fragment, component.getClass().getSimpleName());
        }
    }

    private Fragment findComponentByName(@NotNull String componentName) {
        int index;
        Fragment fragment = null;
        if (!TextUtils.isEmpty((CharSequence)componentName) && (fragment = this.getChildFragmentManager().findFragmentByTag(componentName)) == null && (index = componentName.lastIndexOf(46)) != -1) {
            componentName = componentName.substring(index + 1);
            fragment = this.getChildFragmentManager().findFragmentByTag(componentName);
        }
        return fragment;
    }

    public void detachAllComponent() {
        if (!this.checkActivityValid()) {
            return;
        }
        FragmentManager fm = this.getChildFragmentManager();
        FragmentTransaction ft = fm.beginTransaction();
        Collection<IComponent> values = this.mChildren.values();
        for (IComponent component : values) {
            Fragment f = component.getContent();
            if (f == null || f.isDetached() || !component.isComponentCreated()) continue;
            MLog.debug((Object)TAG, (String)"detach component %s", (Object[])new Object[]{f});
            ft.detach(f);
        }
        ft.commitAllowingStateLoss();
    }

    @Deprecated
    protected void removeComponent(String componentName) {
        Fragment fragment = this.findComponentByName(componentName);
        if (fragment != null) {
            this.getChildFragmentManager().beginTransaction().remove(fragment).commitAllowingStateLoss();
        }
    }

    protected <R extends IComponent> R removeComponent(int compId) {
        Fragment fragment = this.getChildFragmentManager().findFragmentById(compId);
        if (fragment != null) {
            this.getChildFragmentManager().beginTransaction().remove(fragment).commitAllowingStateLoss();
        }
        return (R)((IComponent)fragment);
    }

    @Deprecated
    protected void hideComponent(String componentName) {
        Fragment fragment = this.findComponentByName(componentName);
        if (fragment != null) {
            this.getChildFragmentManager().beginTransaction().hide(fragment).commitAllowingStateLoss();
        }
    }

    @Deprecated
    protected boolean addComponent(String componentName) {
        try {
            Class<?> cls = Class.forName(componentName);
            return this.addComponent(cls);
        }
        catch (ClassNotFoundException e) {
            MLog.error((Object)TAG, (String)"addComponent", (Throwable)e, (Object[])new Object[0]);
            return false;
        }
    }

    public <R extends IComponent> boolean addComponent(Class<R> cls) {
        int compId = this.mComponentMaker.wrapper(cls).resourceId(this.mConfig);
        return this.addComponent(compId, cls);
    }

    public <R extends IComponent> R removeComponent(Class<R> cls) {
        int compId = this.mComponentMaker.wrapper(cls).resourceId(this.mConfig);
        return this.removeComponent(compId);
    }

    public boolean addComponent(int compId, Class<? extends IComponent> cls) {
        Bundle bundle = this.mComponentMaker.wrapper(cls).initBundle(this.mConfigInstance);
        IComponent comp = this.mComponentMaker.of(cls, bundle);
        comp.setTemplate(this.getRoot());
        Fragment fragment = this.getChildFragmentManager().findFragmentById(compId);
        if (fragment == null) {
            this.getChildFragmentManager().beginTransaction().replace(compId, (Fragment)comp, comp.getClass().getSimpleName()).commitAllowingStateLoss();
            return true;
        }
        return false;
    }

    @Deprecated
    protected boolean showComponent(String componentName) {
        try {
            Class<?> cls = Class.forName(componentName);
            return this.showComponent(cls);
        }
        catch (ClassNotFoundException e) {
            MLog.error((Object)TAG, (String)"showComponent", (Throwable)e, (Object[])new Object[0]);
            return false;
        }
    }

    public boolean showComponent(Class<? extends IComponent> cls) {
        int compId = this.mComponentMaker.wrapper(cls).resourceId(this.mConfig);
        Fragment fragment = this.getChildFragmentManager().findFragmentById(compId);
        if (fragment != null && !fragment.isDetached()) {
            this.getChildFragmentManager().beginTransaction().show(fragment).commitAllowingStateLoss();
            return true;
        }
        return false;
    }

    public void addComponent(int resId, IComponent component) {
        Fragment fragment;
        if (component != null && (fragment = this.getChildFragmentManager().findFragmentById(resId)) == null) {
            this.getChildFragmentManager().beginTransaction().replace(resId, (Fragment)component, component.getClass().getSimpleName()).commitAllowingStateLoss();
        }
    }

    @Nullable
    public <R extends IComponent> R getComponent(Class<R> cls) {
        IComponent component = this.mChildren.get(cls);
        if (component == null) {
            Collection<IComponent> list = this.mChildren.values();
            for (IComponent iComponent : list) {
                IComponentContainer container;
                IComponent ret;
                if (!(iComponent instanceof IComponentContainer) || (ret = (container = (IComponentContainer)iComponent).getComponent(cls)) == null) continue;
                return (R)ret;
            }
        } else {
            return (R)component;
        }
        return null;
    }

    public <R extends IComponent> R obtainComponent(Class<R> cls) {
        return this.mComponentMaker.of(cls);
    }

    public <R extends IComponent> R obtainComponent(Class<R> cls, Bundle bundle) {
        return this.mComponentMaker.of(cls, bundle);
    }

    public int customEnterAnimation() {
        return this.transitionAnimation[0];
    }

    public int customExitAnimation() {
        return this.transitionAnimation[1];
    }

    public int getTransition() {
        return this.transit;
    }

    public void setTransition(int transit) {
        this.transit = transit;
    }

    public void overridePendingTransition(int enterAnim, int exitAnim) {
        this.transitionAnimation[0] = enterAnim;
        this.transitionAnimation[1] = exitAnim;
    }

    @Deprecated
    protected void setComponentVisibility(String componentName, int componentVisibility) {
        MLog.info((Object)TAG, (String)("[setComponentVisibility] componentName=" + componentName + ", componentVisibility=" + componentVisibility), (Object[])new Object[0]);
        Fragment fragment = this.findComponentByName(componentName);
        if (fragment == null) {
            MLog.info((Object)TAG, (String)"[setComponentVisibility] fragment is null", (Object[])new Object[0]);
            return;
        }
        View v = fragment.getView();
        if (v == null) {
            MLog.info((Object)TAG, (String)"[setComponentVisibility] v is null", (Object[])new Object[0]);
            return;
        }
        if (1 == componentVisibility) {
            v.setVisibility(4);
        } else if (2 == componentVisibility) {
            v.setVisibility(8);
        } else {
            v.setVisibility(0);
        }
    }

    @BusEvent(sync=true)
    public void onRemoveComponent(ILiveComponentClient_onRemoveComponent_EventArgs busEventArgs) {
        int context = busEventArgs.getContext();
        String componentName = busEventArgs.getComponentName();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("[onRemoveComponent] context=" + context + ", componentName=" + componentName), (Object[])new Object[0]);
        }
        if (context == this.getActivityContext()) {
            this.removeComponent(componentName);
        }
    }

    @BusEvent(sync=true)
    public void onHideComponent(ILiveComponentClient_onHideComponent_EventArgs busEventArgs) {
        int context = busEventArgs.getContext();
        String componentName = busEventArgs.getComponentName();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("[onHideComponent] context=" + context + ", componentName=" + componentName), (Object[])new Object[0]);
        }
        if (context == this.getActivityContext()) {
            this.hideComponent(componentName);
        }
    }

    @BusEvent(sync=true)
    public void onAddComponent(ILiveComponentClient_onAddComponent_EventArgs busEventArgs) {
        int context = busEventArgs.getContext();
        String componentName = busEventArgs.getComponentName();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("[onAddComponent] context=" + context + ", componentName=" + componentName), (Object[])new Object[0]);
        }
        if (context == this.getActivityContext()) {
            this.addComponent(componentName);
        }
    }

    @BusEvent(sync=true)
    public void onShowComponent(ILiveComponentClient_onShowComponent_EventArgs busEventArgs) {
        int context = busEventArgs.getContext();
        String componentName = busEventArgs.getComponentName();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("[onShowComponent] context=" + context + ", componentName=" + componentName), (Object[])new Object[0]);
        }
        if (context == this.getActivityContext()) {
            this.showComponent(componentName);
        }
    }

    @BusEvent(sync=true)
    public void onSetComponentVisibility(ILiveComponentClient_onSetComponentVisibility_EventArgs busEventArgs) {
        int context = busEventArgs.getContext();
        String componentName = busEventArgs.getComponentName();
        int componentVisibility = busEventArgs.getComponentVisibility();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("[onSetComponentVisibility] context=" + context + ", componentName=" + componentName + ", componentVisibility=" + componentVisibility), (Object[])new Object[0]);
        }
        if (context == this.getActivityContext()) {
            this.setComponentVisibility(componentName, componentVisibility);
        }
    }

    @BusEvent(sync=true)
    public void onShowPopupComponent(ILiveComponentClient_onShowPopupComponent_EventArgs busEventArgs) {
        Class clz = busEventArgs.getClz();
        Bundle bundle = busEventArgs.getBundle();
        MLog.info((Object)TAG, (String)("[onShowPopupComponent] clz " + clz.getName()), (Object[])new Object[0]);
        PopupComponent popupComponent = (PopupComponent)Fragment.instantiate((Context)this.getContext(), (String)clz.getName());
        popupComponent.setArguments(bundle);
        this.getRoot().showPopupComponent((IPopupComponent)popupComponent);
    }
}

