/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.basemedia.watchlive.activity;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.duowan.mobile.basemedia.swipe.SwipeViewDelegate;
import com.duowan.mobile.basemedia.watchlive.activity.IViewingRoom;
import com.duowan.mobile.basemedia.watchlive.template.AbstractComponentContainer;
import com.duowan.mobile.basemedia.watchlive.template.ComponentRoot;
import com.duowan.mobile.basemedia.watchlive.template.IChannelBaseParam;
import com.duowan.mobile.basemedia.watchlive.template.IViewScene;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.util.DontProguardClass;
import io.reactivex.Flowable;
import org.jetbrains.annotations.NotNull;

@DontProguardClass
public abstract class DLViewingRoom
implements IViewingRoom<IChannelBaseParam> {
    @NotNull
    private IViewingRoom<IChannelBaseParam> parent;
    private int mState = 0;
    private boolean dontInvokeParent = false;

    public DLViewingRoom(@NotNull IViewingRoom<IChannelBaseParam> parent) {
        this.parent = parent;
    }

    public final void init() {
        this.moveToState(this.parent.getState(), this.parent);
    }

    public final void unInit() {
        this.moveToState(0, this.parent);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        if (!this.dontInvokeParent) {
            this.parent.onCreate(savedInstanceState);
        }
    }

    @Override
    public void onStart() {
        if (!this.dontInvokeParent) {
            this.parent.onStart();
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.parent.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void onResume() {
        if (!this.dontInvokeParent) {
            this.parent.onResume();
        }
    }

    @Override
    public void onPause() {
        if (!this.dontInvokeParent) {
            this.parent.onPause();
        }
    }

    @Override
    public void onStop() {
        if (!this.dontInvokeParent) {
            this.parent.onStop();
        }
    }

    @Override
    public void onDestroy() {
        if (!this.dontInvokeParent) {
            this.parent.onDestroy();
        }
    }

    @Override
    public void attach(Activity proxyActivity) {
        if (!this.dontInvokeParent) {
            this.parent.attach(proxyActivity);
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        this.parent.onSaveInstanceState(outState);
    }

    @Override
    public void onNewIntent(Intent intent) {
        this.parent.onNewIntent(intent);
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
        this.parent.onRestoreInstanceState(savedInstanceState);
    }

    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
        this.parent.onWindowFocusChanged(hasFocus);
    }

    @Override
    public boolean onBackPressed() {
        return this.parent.onBackPressed();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        this.parent.onConfigurationChanged(newConfig);
    }

    @Override
    public boolean interceptFinish() {
        return this.parent.interceptFinish();
    }

    @Override
    public long getSid() {
        return this.parent.getSid();
    }

    @Override
    public long getSSid() {
        return this.parent.getSSid();
    }

    @Override
    public String getTemplateId() {
        return this.parent.getTemplateId();
    }

    @Override
    public IViewScene<IChannelBaseParam> getCurrentScene() {
        return this.parent.getCurrentScene();
    }

    @Override
    public AbstractComponentContainer getCurrentTemplate() {
        return this.parent.getCurrentTemplate();
    }

    @Override
    public ComponentRoot getRoot() {
        return this.parent.getRoot();
    }

    @Override
    public long getAnchorUid() {
        return this.parent.getAnchorUid();
    }

    @Override
    public IChannelBaseParam getChannelBaseParam() {
        return this.parent.getChannelBaseParam();
    }

    @Override
    public final Activity getActivity() {
        return this.parent.getActivity();
    }

    @Override
    public DialogLinkManager getDialogManager() {
        return this.parent.getDialogManager();
    }

    @Override
    public Flowable<IViewScene<IChannelBaseParam>> updateChannelInfo(IChannelBaseParam param) {
        return this.parent.updateChannelInfo(param);
    }

    @Override
    public Flowable<IViewScene<IChannelBaseParam>> updateChannelInfo(Bundle bundle) {
        return this.parent.updateChannelInfo(bundle);
    }

    @Override
    public Flowable<IViewScene<IChannelBaseParam>> updateChannelInfo(String templateId, long sid, long ssid) {
        return this.parent.updateChannelInfo(templateId, sid, ssid);
    }

    @Override
    public Flowable<IViewScene<IChannelBaseParam>> updateChannelInfo(String templateId, long sid, long ssid, int liveType) {
        return this.parent.updateChannelInfo(templateId, sid, ssid, liveType);
    }

    @Override
    public void applySceneToRoot(String functionName) {
        this.parent.applySceneToRoot(functionName);
    }

    @Override
    public void applySceneToRoot(IViewScene scene) {
        this.parent.applySceneToRoot(scene);
    }

    @Override
    public void applySceneToRoot(IViewScene scene, String functionName) {
        this.parent.applySceneToRoot(scene, functionName);
    }

    @Override
    public void applySceneToRoot(String functionName, int transit) {
        this.parent.applySceneToRoot(functionName, transit);
    }

    @Override
    public void onAllUIComponentDone() {
        this.parent.onAllUIComponentDone();
    }

    @NonNull
    public IViewingRoom<IChannelBaseParam> getParent() {
        return this.parent;
    }

    protected void setParent(@NotNull IViewingRoom<IChannelBaseParam> parent) {
        this.parent = parent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void moveToState(int parentState, IViewingRoom parent) {
        this.dontInvokeParent = true;
        try {
            if (parentState > this.mState) {
                switch (this.mState) {
                    case 0: {
                        this.attach(parent.getActivity());
                    }
                    case 1: {
                        this.onCreate(parent.getSavedInstanceState());
                    }
                    case 2: 
                    case 3: {
                        this.onStart();
                    }
                    case 4: {
                        this.onResume();
                        break;
                    }
                }
                this.mState = parentState;
                return;
            }
            if (parentState >= this.mState) return;
            switch (this.mState) {
                case 5: {
                    this.onPause();
                }
                case 4: {
                    this.onStop();
                }
                case 1: 
                case 2: 
                case 3: {
                    if (parentState >= 2) return;
                    this.onDestroy();
                    return;
                }
            }
            return;
        }
        finally {
            this.dontInvokeParent = false;
        }
    }

    @Override
    public SwipeViewDelegate getSwipeListener() {
        return null;
    }

    @Override
    public int getState() {
        return this.parent.getState();
    }

    @Override
    public Bundle getSavedInstanceState() {
        return this.parent.getSavedInstanceState();
    }

    @Override
    public void autoSwapToNextChannel() {
        this.parent.autoSwapToNextChannel();
    }

    protected boolean checkActivityValid() {
        return this.getActivity() != null && !this.getActivity().isFinishing() && (Build.VERSION.SDK_INT < 17 || !this.getActivity().isDestroyed());
    }
}

