/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.entlive.proccessor;

import com.duowan.mobile.entlive.annotation.ModuleConfigInitialize;
import com.duowan.mobile.entlive.annotation.ModuleConfigs;
import com.duowan.mobile.entlive.utils.ELModuleConfigUtilForBuild;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class ELModulesProcessorUtil {
    public static void handleELModules(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, Messager messager) {
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(ModuleConfigs.class);
        ClassName hashMapCN = ClassName.get((String)"java.util", (String)"LinkedHashMap", (String[])new String[0]);
        ClassName ientModuleCN = ClassName.get((String)"com.duowan.mobile.entlive.domain", (String)"IEntModule", (String[])new String[0]);
        ParameterizedTypeName hashMapTN = ParameterizedTypeName.get((ClassName)hashMapCN, (TypeName[])new TypeName[]{TypeName.get(String.class), ientModuleCN});
        for (Element element : set) {
            if (element.getKind() == ElementKind.CLASS) {
                CodeBlock.Builder builder = CodeBlock.builder();
                builder.addStatement("$T<String, $T> moduleMap = new $T<>()", new Object[]{hashMapCN, ientModuleCN, hashMapCN});
                ModuleConfigs moduleWrapper = element.getAnnotation(ModuleConfigs.class);
                ModuleConfigInitialize config = moduleWrapper.initialize();
                String componentName = ELModuleConfigUtilForBuild.convertToModuleGroupKey((ProcessingEnvironment)processingEnv, (ModuleConfigs)moduleWrapper);
                try {
                    config.moduleMembers();
                }
                catch (MirroredTypesException e) {
                    builder.beginControlFlow("if (templateName.equals($S))", new Object[]{componentName});
                    for (TypeMirror typeMirror : e.getTypeMirrors()) {
                        TypeElement classTypeElement = ELModulesProcessorUtil.asTypeElement(processingEnv, typeMirror);
                        builder.addStatement("moduleMap.put($S,new $T())", new Object[]{classTypeElement.getQualifiedName(), classTypeElement});
                    }
                    builder.addStatement("return moduleMap", new Object[0]).endControlFlow();
                }
                MethodSpec createModules = MethodSpec.methodBuilder((String)"createModules").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).returns((TypeName)hashMapTN).addParameter(String.class, "templateName", new Modifier[0]).addCode(builder.build()).addStatement("return moduleMap", new Object[0]).build();
                ClassName componentCls = ClassName.bestGuess((String)componentName);
                TypeSpec typeSpec = TypeSpec.classBuilder((String)(componentCls.simpleName() + "$$ELModulesFactory")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(ClassName.get((String)"com.yy.mobile.util", (String)"DontProguardClass", (String[])new String[0])).addMethod(createModules).build();
                JavaFile javaFile = JavaFile.builder((String)componentCls.packageName(), (TypeSpec)typeSpec).build();
                try {
                    javaFile.writeTo(processingEnv.getFiler());
                }
                catch (IOException iOException) {}
                continue;
            }
            messager.printMessage(Diagnostic.Kind.NOTE, "only support class");
        }
    }

    public static TypeElement asTypeElement(ProcessingEnvironment processingEnv, TypeMirror typeMirror) {
        Types typeutils = processingEnv.getTypeUtils();
        return (TypeElement)typeutils.asElement(typeMirror);
    }
}

