/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.ipcapi.util;

import android.text.TextUtils;
import com.unionyy.ipcapi.annotation.MethodId;
import com.unionyy.ipcapi.util.HermesException;
import com.unionyy.ipcapi.util.TypeUtils;
import com.unionyy.ipcapi.wrapper.BaseWrapper;
import com.unionyy.ipcapi.wrapper.MethodWrapper;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public class TypeCenter {
    private static volatile TypeCenter sInstance = null;
    private final ConcurrentHashMap<String, Class<?>> mAnnotatedClasses = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Class<?>> mRawClasses = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, Method>> mAnnotatedMethods = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, Method>> mRawMethods = new ConcurrentHashMap();

    private TypeCenter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeCenter getInstance() {
        if (sInstance != null) return sInstance;
        Class<TypeCenter> clazz = TypeCenter.class;
        synchronized (TypeCenter.class) {
            if (sInstance != null) return sInstance;
            sInstance = new TypeCenter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private void registerClass(Class<?> clazz) {
        String classId = TypeUtils.getClassId(clazz);
        if (classId == null) {
            String className = clazz.getName();
            this.mRawClasses.putIfAbsent(className, clazz);
        } else {
            this.mAnnotatedClasses.putIfAbsent(classId, clazz);
        }
    }

    private void registerMethod(Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            String key;
            ConcurrentHashMap<String, Method> map;
            MethodId methodId = method.getAnnotation(MethodId.class);
            if (methodId == null) {
                this.mRawMethods.putIfAbsent(clazz, new ConcurrentHashMap());
                map = this.mRawMethods.get(clazz);
                key = TypeUtils.getMethodId(method);
                map.putIfAbsent(key, method);
                continue;
            }
            this.mAnnotatedMethods.putIfAbsent(clazz, new ConcurrentHashMap());
            map = this.mAnnotatedMethods.get(clazz);
            key = TypeUtils.getMethodId(method);
            map.putIfAbsent(key, method);
        }
    }

    public void register(Class<?> clazz) {
        TypeUtils.validateClass(clazz);
        this.registerClass(clazz);
        this.registerMethod(clazz);
    }

    public Class<?> getClassType(BaseWrapper wrapper) throws HermesException {
        String name = wrapper.getName();
        if (TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        if (wrapper.isName()) {
            Class<Object> clazz = this.mRawClasses.get(name);
            if (clazz != null) {
                return clazz;
            }
            if (name.equals("boolean")) {
                clazz = Boolean.TYPE;
            } else if (name.equals("byte")) {
                clazz = Byte.TYPE;
            } else if (name.equals("char")) {
                clazz = Character.TYPE;
            } else if (name.equals("short")) {
                clazz = Short.TYPE;
            } else if (name.equals("int")) {
                clazz = Integer.TYPE;
            } else if (name.equals("long")) {
                clazz = Long.TYPE;
            } else if (name.equals("float")) {
                clazz = Float.TYPE;
            } else if (name.equals("double")) {
                clazz = Double.TYPE;
            } else if (name.equals("void")) {
                clazz = Void.TYPE;
            } else {
                try {
                    clazz = Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    throw new HermesException(16, "Cannot find class " + name + ". Classes without ClassId annotation on it should be located at the same package and have the same name, EVEN IF the source code has been obfuscated by Proguard.");
                }
            }
            this.mRawClasses.putIfAbsent(name, clazz);
            return clazz;
        }
        Class<?> clazz = this.mAnnotatedClasses.get(name);
        if (clazz == null) {
            throw new HermesException(16, "Cannot find class with ClassId annotation on it. ClassId = " + name + ". Please add the same annotation on the corresponding class in the remote process and register it. Have you forgotten to register the class?");
        }
        return clazz;
    }

    public Class<?>[] getClassTypes(BaseWrapper[] wrappers) throws HermesException {
        Class[] classes = new Class[wrappers.length];
        for (int i = 0; i < wrappers.length; ++i) {
            classes[i] = this.getClassType(wrappers[i]);
        }
        return classes;
    }

    public Method getMethod(Class<?> clazz, MethodWrapper methodWrapper) throws HermesException {
        String name = methodWrapper.getName();
        if (methodWrapper.isName()) {
            this.mRawMethods.putIfAbsent(clazz, new ConcurrentHashMap());
            ConcurrentHashMap<String, Method> methods = this.mRawMethods.get(clazz);
            Method method = methods.get(name);
            if (method != null) {
                TypeUtils.methodReturnTypeMatch(method, methodWrapper);
                return method;
            }
            int pos = name.indexOf(40);
            method = TypeUtils.getMethod(clazz, name.substring(0, pos), this.getClassTypes(methodWrapper.getParameterTypes()), this.getClassType(methodWrapper.getReturnType()));
            if (method == null) {
                throw new HermesException(17, "Method not found: " + name + " in class " + clazz.getName());
            }
            methods.put(name, method);
            return method;
        }
        ConcurrentHashMap<String, Method> methods = this.mAnnotatedMethods.get(clazz);
        Method method = methods.get(name);
        if (method != null) {
            TypeUtils.methodMatch(method, methodWrapper);
            return method;
        }
        throw new HermesException(17, "Method not found in class " + clazz.getName() + ". Method id = " + name + ". Please add the same annotation on the corresponding method in the remote process.");
    }
}

