/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.ipcapi.internal;

import android.os.RemoteException;
import android.util.Log;
import com.unionyy.ipcapi.internal.CallbackMail;
import com.unionyy.ipcapi.internal.IHermesServiceCallback;
import com.unionyy.ipcapi.internal.Reply;
import com.unionyy.ipcapi.util.HermesException;
import com.unionyy.ipcapi.util.TypeUtils;
import com.unionyy.ipcapi.wrapper.MethodWrapper;
import com.unionyy.ipcapi.wrapper.ParameterWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class HermesCallbackInvocationHandler
implements InvocationHandler {
    private static final String TAG = "HERMES_CALLBACK";
    private long mTimeStamp;
    private int mIndex;
    private IHermesServiceCallback mCallback;

    public HermesCallbackInvocationHandler(long timeStamp, int index, IHermesServiceCallback callback) {
        this.mTimeStamp = timeStamp;
        this.mIndex = index;
        this.mCallback = callback;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] objects) {
        try {
            MethodWrapper methodWrapper = new MethodWrapper(method);
            ParameterWrapper[] parameterWrappers = TypeUtils.objectToWrapper(objects);
            CallbackMail callbackMail = new CallbackMail(this.mTimeStamp, this.mIndex, methodWrapper, parameterWrappers);
            Reply reply = this.mCallback.callback(callbackMail);
            if (reply == null) {
                return null;
            }
            if (reply.success()) {
                return reply.getResult();
            }
            Log.e((String)TAG, (String)("Error occurs: " + reply.getMessage()));
            return null;
        }
        catch (HermesException e) {
            Log.e((String)TAG, (String)"Error occurs but does not crash the app.", (Throwable)e);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error occurs but does not crash the app.", (Throwable)e);
        }
        return null;
    }
}

