/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.creategiftpk.ui;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.yy.mobile.creategiftpk.R;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.ui.common.AbsStatusFragment;
import com.yy.mobile.util.NetworkUtils;
import com.yymobile.baseapi.R;

public class NoDataSmallFragment
extends AbsStatusFragment {
    public static final String TIP_PARAM = "TIP_PARAM";
    public static final String DRAWABLE_PARAM = "DRAWABLE_PARAM";
    private CharSequence mTip;
    private int mDrawable;
    private View.OnClickListener mSelfListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (!NetworkUtils.isNetworkStrictlyAvailable((Context)NoDataSmallFragment.this.getActivity())) {
                NoDataSmallFragment.this.checkNetToast();
                return;
            }
            if (NoDataSmallFragment.this.mLoadListener != null) {
                NoDataSmallFragment.this.mLoadListener.onClick(v);
            }
        }
    };

    public static NoDataSmallFragment newInstance() {
        return new NoDataSmallFragment();
    }

    public static NoDataSmallFragment newInstance(int drawable2, CharSequence tips) {
        Bundle bundle = new Bundle();
        bundle.putCharSequence(TIP_PARAM, tips);
        bundle.putInt(DRAWABLE_PARAM, drawable2);
        NoDataSmallFragment fragment = new NoDataSmallFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        RecycleImageView imageView;
        View view = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.fragment_no_data_layout, container, false);
        view.setOnClickListener(this.mSelfListener);
        if (savedInstanceState != null) {
            this.mTip = savedInstanceState.getCharSequence(TIP_PARAM);
            this.mDrawable = savedInstanceState.getInt(DRAWABLE_PARAM, R.drawable.icon_neirongkong);
        } else {
            Bundle bundle = this.getArguments();
            if (bundle != null) {
                this.mTip = bundle.getCharSequence(TIP_PARAM);
                this.mDrawable = bundle.getInt(DRAWABLE_PARAM, R.drawable.icon_neirongkong);
            } else {
                this.mTip = this.getString(R.string.no_list_data);
                this.mDrawable = R.drawable.icon_neirongkong;
            }
        }
        if (this.mTip == null || this.mTip.length() <= 0) {
            this.mTip = this.getString(R.string.no_list_data);
        }
        if (this.mDrawable <= 0) {
            this.mDrawable = R.drawable.icon_neirongkong;
        }
        if ((imageView = (RecycleImageView)view.findViewById(R.id.no_data_icon)) != null) {
            ImageLoader.loadImageResource((int)this.mDrawable, (RecycleImageView)imageView, (ImageConfig)ImageConfig.fullImageConfig());
            imageView.setImageDrawable(this.getResources().getDrawable(this.mDrawable));
        }
        TextView textView = (TextView)view.findViewById(R.id.no_data_text);
        textView.setText(this.mTip);
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putCharSequence(TIP_PARAM, this.mTip);
        outState.putInt(DRAWABLE_PARAM, this.mDrawable);
    }
}

