/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.creategiftpk;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import com.yy.mobile.ui.basicchanneltemplate.component.PopupComponent;
import com.yy.mobile.util.StringUtils;

public class Utils {
    public static void showPopupComponent(Activity act, FragmentManager manager, Class<? extends PopupComponent> cls, String tag) {
        Utils.showPopupComponent(act, manager, null, cls, tag);
    }

    public static Fragment hideComponent(Activity act, FragmentManager manager, String tag, boolean executePendingTransactions) {
        if (act == null || act.isFinishing()) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 17 && act.isDestroyed()) {
            return null;
        }
        if (manager == null || tag == null) {
            return null;
        }
        Fragment fragment = manager.findFragmentByTag(tag);
        FragmentTransaction ft = manager.beginTransaction();
        if (fragment != null && !fragment.isHidden()) {
            ft.hide(fragment).commitAllowingStateLoss();
        }
        if (executePendingTransactions) {
            manager.executePendingTransactions();
        }
        return fragment;
    }

    public static Fragment hideComponent(Activity act, FragmentManager manager, String tag) {
        return Utils.hideComponent(act, manager, tag, false);
    }

    public static Fragment removeComponent(Activity act, FragmentManager manager, String tag, boolean executePendingTransactions) {
        if (act == null || act.isFinishing()) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 17 && act.isDestroyed()) {
            return null;
        }
        if (manager == null || tag == null) {
            return null;
        }
        Fragment fragment = manager.findFragmentByTag(tag);
        FragmentTransaction ft = manager.beginTransaction();
        if (fragment != null) {
            ft.remove(fragment).commitAllowingStateLoss();
        }
        if (executePendingTransactions) {
            manager.executePendingTransactions();
        }
        return fragment;
    }

    public static Fragment removeComponent(Activity act, FragmentManager manager, String tag) {
        return Utils.removeComponent(act, manager, tag, false);
    }

    public static Fragment showPopupComponent(Activity act, FragmentManager manager, Bundle bundle, Class<? extends PopupComponent> cls, String tag) {
        Bundle arguments;
        if (act == null || act.isFinishing()) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 17 && act.isDestroyed()) {
            return null;
        }
        if (manager == null || cls == null) {
            return null;
        }
        Fragment fragment = manager.findFragmentByTag(tag);
        if (fragment == null) {
            fragment = bundle != null ? Fragment.instantiate((Context)act, (String)cls.getCanonicalName(), (Bundle)bundle) : Fragment.instantiate((Context)act, (String)cls.getCanonicalName());
        }
        if (bundle != null && (arguments = fragment.getArguments()) != null) {
            arguments.putAll(bundle);
        }
        if (!fragment.isAdded()) {
            ((PopupComponent)fragment).show(manager, tag);
        }
        return fragment;
    }

    public static Fragment loadFragment(Activity act, int containerId, FragmentManager manager, Bundle bundle, Class<? extends Fragment> cls, String tag) {
        Bundle arguments;
        if (act == null || act.isFinishing()) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 17 && act.isDestroyed()) {
            return null;
        }
        if (manager == null || cls == null) {
            return null;
        }
        Fragment fragment = null;
        if (!StringUtils.isEmpty((String)tag).booleanValue()) {
            fragment = manager.findFragmentByTag(tag);
        }
        FragmentTransaction ft = manager.beginTransaction();
        if (fragment == null) {
            fragment = bundle != null ? Fragment.instantiate((Context)act, (String)cls.getCanonicalName(), (Bundle)bundle) : Fragment.instantiate((Context)act, (String)cls.getCanonicalName());
        }
        if (fragment.isDetached()) {
            ft.attach(fragment);
        } else if (!fragment.isAdded()) {
            if (!StringUtils.isEmpty((String)tag).booleanValue()) {
                ft.add(containerId, fragment, tag);
            } else {
                ft.replace(containerId, fragment);
            }
        } else if (fragment.isHidden()) {
            ft.show(fragment);
        }
        if (bundle != null && (arguments = fragment.getArguments()) != null) {
            arguments.putAll(bundle);
        }
        ft.commitAllowingStateLoss();
        return fragment;
    }

    public static Fragment replaceFragment(Activity act, int containerId, FragmentManager manager, Bundle bundle, Class<? extends Fragment> cls, String tag) {
        if (act == null || act.isFinishing()) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 17 && act.isDestroyed()) {
            return null;
        }
        if (manager == null || cls == null) {
            return null;
        }
        FragmentTransaction ft = manager.beginTransaction();
        Fragment fragment = bundle != null ? Fragment.instantiate((Context)act, (String)cls.getCanonicalName(), (Bundle)bundle) : Fragment.instantiate((Context)act, (String)cls.getCanonicalName());
        if (!StringUtils.isEmpty((String)tag).booleanValue()) {
            ft.replace(containerId, fragment, tag);
        } else {
            ft.replace(containerId, fragment);
        }
        ft.commitAllowingStateLoss();
        return fragment;
    }
}

