/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.hiido;

import android.annotation.SuppressLint;
import android.content.Context;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.api.OnStatisListener;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.inner.util.log.L;
import com.yy.mobile.baseapi.model.store.YYState;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.hiido.HiidoStatisticHelper;
import com.yy.mobile.hiido.SpdtHiidoInitOption;
import com.yy.mobile.uniondif.AppIdConfig;
import com.yy.mobile.util.AppMetaDataUtil;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;

public class HiidoManager {
    public static final String TAG = "HiidoManager";
    public static final String HIIDO_ENV_SETTINGS_PREF_KEY = "HIIDO_ENV_SETTINGS_PREF_KEY";
    public static final int HIIDO_ENV_SETTINGS_VALUE_PRODUCT = 1;
    public static final int HIIDO_ENV_SETTINGS_VALUE_TEST = 2;
    public static final String UMENG_INIT_BEGIN = "UmengInitBegin";
    public static final String UMENG_INIT_END = "UmengInitEnd";
    public static final String PUSH_INIT_BEGIN = "PushInitBegin";
    public static final String PUSH_INIT_END = "PushInitEnd";
    public static final String PUSH_CALLBACK_REGISTER = "PushCallbackRegister";
    public static final String PUSH_CALLBACK_SUCCESS = "PushCallbackSuccess";
    public static final String PUSH_CALLBACK_FAILED = "PushCallbackFailed";
    public static final String HIDDO_ENV_ACT_KEY = "mbsdkquality";
    public static final String HIDDO_ENV_TOPIC_KEY = "topic";
    public static final String HIDDO_ENV_TOPIC_VALUE = "pushComponent";
    public static final String HIDDO_ENV_EVENT_KEY = "event";
    public static final String HIDDO_ENV_MSG_KEY = "msg";
    public static final String HIDDO_ENV_DEFAULT = "non";

    public static void initHiido(Context context) {
        int hiidoSettingPrefValue;
        MLog.info((Object)TAG, (String)"initHiido", (Object[])new Object[0]);
        OnStatisListener listener = new OnStatisListener(){

            public long getCurrentUid() {
                long currentUid = 0L;
                if (YYStore.INSTANCE.getState() != null) {
                    currentUid = ((YYState)YYStore.INSTANCE.getState()).getCurrentUid();
                    MLog.info((Object)HiidoManager.TAG, (String)("currentUid value is " + currentUid), (Object[])new Object[0]);
                }
                MLog.info((Object)HiidoManager.TAG, (String)("get uid =" + currentUid), (Object[])new Object[0]);
                return currentUid;
            }
        };
        boolean useTestServer = false;
        if (BasicConfig.getInstance().isDebuggable() && (hiidoSettingPrefValue = CommonPref.instance().getInt(HIIDO_ENV_SETTINGS_PREF_KEY, 1)) == 2) {
            useTestServer = true;
        }
        if (null != YYActivityManager.INSTANCE.getApplication()) {
            context = YYActivityManager.INSTANCE.getApplication();
        }
        MLog.info((Object)TAG, (String)("useTestServer:" + useTestServer), (Object[])new Object[0]);
        HiidoStatisticHelper.initHiidoSdk(context, listener, null, useTestServer ? HiidoStatisticHelper.STATISTIC_HIIDO_TEST_SERVER : null, AppMetaDataUtil.getChannelID((Context)context), false, AppIdConfig.INSTANCE.getAppIds() == null ? "" : AppIdConfig.INSTANCE.getAppIds().getHiidoAppKey());
        SpdtHiidoInitOption hiidoInitOption = (SpdtHiidoInitOption)Spdt.of(SpdtHiidoInitOption.class);
        if (hiidoInitOption != null) {
            hiidoInitOption.registerLifeCycle(context);
        }
        L.setLogOn((boolean)true);
    }

    @SuppressLint(value={"CheckResult"})
    public static void pilingHiidoStatisticContent(String customEvent, String msg) {
        MLog.info((Object)TAG, (String)"PilingHiidoStatistic Event\uff1a%s, Msg:%s", (Object[])new Object[]{customEvent, msg});
        StatisContent content = new StatisContent();
        content.put(HIDDO_ENV_TOPIC_KEY, HIDDO_ENV_TOPIC_VALUE);
        content.put(HIDDO_ENV_EVENT_KEY, customEvent);
        content.put(HIDDO_ENV_MSG_KEY, msg);
        HiidoSDK.instance().reportStatisticContent(HIDDO_ENV_ACT_KEY, content);
    }
}

