package com.duowan.mobile.main.kinds.wrapper

import com.duowan.mobile.main.kinds.Kind
import com.duowan.mobile.main.kinds.KindStorage

/**
 * [StringKindValue]
 *
 * @param <T>
</T> */
abstract class StringKindWrapper<T : Kind>(
    storage: KindStorage, storageKey: String,
    dfValue: String, clz: Class<T>, valueCount: Int,
    alias: String, group: String
) : MixedKindWrapper<T, String>(storage, storageKey, dfValue, clz, valueCount, alias, group) {

    override fun storageValue(): String {
        return mStorage.getString(storageKey(), mDefaultValue)
    }

    override fun storeValue(value: String) {
        mStorage.putString(storageKey(), value)
    }

    override fun type(): Class<*> {
        return String::class.java
    }
}