package com.duowan.mobile.main.kinds.wrapper

import com.duowan.mobile.main.kinds.Kind
import com.duowan.mobile.main.kinds.KindStorage

abstract class AbstractKindWrapper<T : Kind, TYPE> protected constructor(
    val mStorage: KindStorage, val mStorageKey: String,
    val mDefaultValue: TYPE, val mAlias: String, val mGroup: String
) : KindWrapper<T, TYPE> {

    override fun storageKey(): String {
        return mStorageKey
    }

    override fun alias(): String {
        return mAlias
    }

    override fun group(): String {
        return mGroup
    }

    override fun enableForDebug(): Boolean {
        return false
    }
}