package com.duowan.mobile.main.kinds

import java.util.concurrent.CopyOnWriteArrayList

/**
 * create by zhengyongxin on 2019/6/19
 * 用于参数注入
 */
class KindInjectUtil private constructor() : IKindInject {
    private val classCache: LruCache<String, IKindInject> = LruCache(66)
    private val blackList: MutableList<String>

    init {
        blackList = CopyOnWriteArrayList()
    }

    override fun inject(target: Any) {
        injectInner(target)
    }

    private fun injectInner(target: Any) {
        var clazz: Class<*>? = target.javaClass
        do {
            val className = clazz!!.name
            try {
                if (!blackList.contains(className)) {
                    var kindInject = classCache.get(className)
                    if (null == kindInject) {
                        kindInject = Class.forName(className + Const.NAME_OF_INJECT).getConstructor()
                            .newInstance() as IKindInject
                    }
                    kindInject.inject(target)
                    classCache.put(className, kindInject)
                }
            } catch (e: ClassNotFoundException) {
                blackList.add(className) // This instance need not autowired.
            } catch (e: Exception) {
                blackList.add(className) // This instance need not autowired.
            }

            clazz = clazz.superclass
        } while (clazz != null)
    }

    companion object {

        val instance = KindInjectUtil()
    }
}
