package com.duowan.mobile.main.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 如果字段需要注入参数值，使用该注解。
 * 支持数据类型：String, Char, Int, Long, Short, Double, Float, Boolean, Object, 详细用法建议查看项目Demo
 * demo:
 *
 * @KindsLayer( layerId = "kinds_test1", alias = "abTest sdk用例实验1", defaultTest = 0 )
 * abstract class IAbTestUserCaseTest1 : Kind {
 *
 *      @KindsInject(name = "text", desc = "文案")
 *      var text:String? //当请求值不为空时，会在第一次创建时更新
 *
 *      abstract fun getText(): String
 * }
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.CLASS)
public @interface KindsInject {
    /**
     * 参数id，不填默认为字段名
     */
    String value() default "";

    /**
     * 字段的描述
     */
    String desc() default "No desc.";
}
