/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.main.kinds.wrapper;

import com.duowan.mobile.main.kinds.Kind;
import com.duowan.mobile.main.kinds.KindStorage;
import com.duowan.mobile.main.kinds.wrapper.AbstractKindWrapper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class MixedKindWrapper<T extends Kind, TYPE>
extends AbstractKindWrapper<T, TYPE> {
    protected final Map<TYPE, Integer> mIndexMap;
    private final int mValueCount;
    private final T[] mInstance;
    private final Class[] mImplClasses;

    public MixedKindWrapper(KindStorage storage, String storageKey, TYPE dfValue, Class<T> clz, int valueCount, String alias, String group) {
        super(storage, storageKey, dfValue, alias, group);
        this.mValueCount = valueCount;
        this.mInstance = (Kind[])Array.newInstance(clz, this.mValueCount);
        this.mImplClasses = (Class[])Array.newInstance(Class.class, this.mValueCount);
        this.mIndexMap = new HashMap<TYPE, Integer>();
        this.initializeIndex();
    }

    @Override
    public final T instance() {
        if (this.mIndexMap.isEmpty()) {
            throw null;
        }
        Object value = this.storageValue();
        Integer index = this.mIndexMap.containsKey(value) ? this.mIndexMap.get(value) : this.mIndexMap.get(this.mDefaultValue);
        System.out.print("MixedKindWrapper index = " + index);
        return this.instanceOfIndex(index);
    }

    private T instanceOfIndex(int index) {
        if (this.mInstance[index] == null) {
            this.mInstance[index] = this.createInstance(index);
        }
        return this.mInstance[index];
    }

    private T createInstance(int index) {
        Class clz = this.mImplClasses[index];
        try {
            return (T)((Kind)clz.newInstance());
        }
        catch (Exception e) {
            return null;
        }
    }

    protected final void mapIndex(TYPE value, int index, Class<? extends T> implClass) {
        this.mIndexMap.put(value, index);
        this.mImplClasses[index] = implClass;
    }

    @Override
    public void store(TYPE value) {
        Object oldValue = this.storageValue();
        if (value.equals(oldValue)) {
            return;
        }
        Set<TYPE> ketSet = this.mIndexMap.keySet();
        if (ketSet.isEmpty()) {
            this.storeValue(value);
        } else {
            for (TYPE v : this.mIndexMap.keySet()) {
                if (!v.equals(value)) continue;
                this.storeValue(value);
            }
        }
    }

    @Override
    public void storeInstance(T instance) {
        int index;
        for (index = 0; index < this.mValueCount && this.mInstance[index] != instance; ++index) {
        }
        if (index >= this.mValueCount) {
            return;
        }
        for (Map.Entry<TYPE, Integer> entry : this.mIndexMap.entrySet()) {
            if (entry.getValue() != index) continue;
            this.store(entry.getKey());
            break;
        }
    }

    protected abstract void initializeIndex();

    protected abstract void storeValue(TYPE var1);

    @Override
    public List<Kind> getAllFeaturesInstance() {
        ArrayList<Kind> result = new ArrayList<Kind>();
        for (int i = 0; i < this.mValueCount; ++i) {
            if (this.mInstance[i] != null) {
                result.add((Kind)this.mInstance[i]);
                continue;
            }
            result.add((Kind)this.createInstance(i));
        }
        return result;
    }

    @Override
    public TYPE getValueByIndex(int index) {
        for (Map.Entry<TYPE, Integer> typeValue : this.mIndexMap.entrySet()) {
            if (index != typeValue.getValue()) continue;
            return typeValue.getKey();
        }
        return null;
    }
}

