/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.main.kinds.wrapper;

import com.duowan.mobile.main.kinds.Kind;
import com.duowan.mobile.main.kinds.KindStorage;
import com.duowan.mobile.main.kinds.wrapper.AbstractKindWrapper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public abstract class BooleanKindWrapper<T extends Kind>
extends AbstractKindWrapper<T, Boolean> {
    private final T[] mInstance;
    private final boolean mEnableDebug;

    public BooleanKindWrapper(KindStorage storage, String storageKey, boolean dfValue, Class<T> clz, String alias, String group) {
        this(storage, storageKey, dfValue, clz, alias, group, false);
    }

    public BooleanKindWrapper(KindStorage storage, String storageKey, boolean dfValue, Class<T> clz, String alias, String group, boolean enableDebug) {
        super(storage, storageKey, dfValue, alias, group);
        this.mInstance = (Kind[])Array.newInstance(clz, 2);
        this.mEnableDebug = enableDebug;
    }

    @Override
    public final T instance() {
        boolean value = this.storageValue();
        return this.instanceOfValue(value);
    }

    private T instanceOfValue(boolean value) {
        int index;
        int n = index = value ? 1 : 0;
        if (this.mInstance[index] == null) {
            this.mInstance[index] = this.createInstance(value);
        }
        return this.mInstance[index];
    }

    @Override
    public final Class type() {
        return Boolean.TYPE;
    }

    @Override
    public final Boolean storageValue() {
        return this.mEnableDebug && this.mStorage.isDebug() || this.mStorage.getBoolean(this.storageKey(), (Boolean)this.mDefaultValue);
    }

    @Override
    public final void store(Boolean value) {
        boolean old = this.storageValue();
        if (old != value) {
            this.mStorage.putBoolean(this.storageKey(), value);
        }
    }

    @Override
    public final void store(Integer value) {
        this.store(value != 0);
    }

    @Override
    public final void storeInstance(T instance) {
        if (instance == this.mInstance[0]) {
            this.store(true);
        } else if (instance == this.mInstance[1]) {
            this.store(false);
        }
    }

    @Override
    public boolean enableForDebug() {
        return this.mEnableDebug;
    }

    protected abstract T createInstance(boolean var1);

    @Override
    public List<Kind> getAllFeaturesInstance() {
        ArrayList<Kind> result = new ArrayList<Kind>();
        result.add((Kind)this.instanceOfValue(true));
        result.add((Kind)this.instanceOfValue(false));
        return result;
    }

    @Override
    public Boolean getValueByIndex(int index) {
        if (index < 0) {
            throw new RuntimeException("index must not small 0");
        }
        return index == 0;
    }
}

