package com.yy.pushsvc.yunlog.weaknetlog;

import android.app.IntentService;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;

import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.yunlog.IYunLog;
import com.yy.pushsvc.yunlog.KLogW;
import com.yy.pushsvc.yunlog.aliyun.YunLogConfig;

import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import androidx.annotation.Nullable;

/**
 * Created by xudadade on 2019/1/14
 */
public class LogUploadService extends IntentService {
    private static String TAG = "FileUploadService";

    private IYunLog mLogImpl = null;
    SimpleDateFormat mSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
    private static long ONE_DAY_MILLS = 24 * 60 * 60 * 1000;

    public LogUploadService() {
        super("FileUploadService");
        mLogImpl = KLogW.getYunLogImpl();
    }

    @Override
    protected void onHandleIntent(@Nullable Intent intent) {
        uploadLogs();

    }

    private void uploadLogs() {
        FileReader reader = null;
        BufferedReader bfReader = null;
        try {
            synchronized (LogCacheService.mLock) {
                copyFile();
            }
            File file = new File(LogCacheService.getInstance().getFailCopyPath());
            if (file.exists()) {
                reader = new FileReader(LogCacheService.getInstance().getFailCopyPath());
                bfReader = new BufferedReader(reader);
                String logLine = null;
                while (!TextUtils.isEmpty(logLine = bfReader.readLine())) {
                    upload(logLine);
                }
                deleteCopyFile();
            }

        } catch (Throwable e) {
            PushLog.inst().log(TAG + "  upload file error" );
        } finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (bfReader != null) {
                    bfReader.close();
                }
            } catch (Throwable e) {
                PushLog.inst().log(TAG + "  close bfread error" );
            }
        }
    }

    private boolean copyFile() {
        try {
            File oldFile = new File(LogCacheService.getInstance().getFailPath());
            File newFile = new File(LogCacheService.getInstance().getFailCopyPath());
            if (newFile.exists()) {
                return true;
            }
            if (!newFile.exists() && oldFile.exists()) {
                oldFile.renameTo(newFile);
                oldFile.delete();
                return true;
            }
        } catch (Throwable t) {
            Log.i(TAG, t.toString());
        }
        return false;
    }

    private void deleteCopyFile() {
        try {
            File newFile = new File(LogCacheService.getInstance().getFailCopyPath());
            if (newFile.exists()) {
                newFile.delete();
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + " delete File error" );
        }
    }

    private void upload(String data) {
        try {
            if (!TextUtils.isEmpty(data) && data.endsWith("}")) {
                JSONObject pa = new JSONObject(data);
                String time = pa.optString("time");
                long timeInterval = System.currentTimeMillis() - getTimeMillis(time);
                if (timeInterval < ONE_DAY_MILLS) {                      //只上传一天之内的log
                    reportCommonLog(data);
                }
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + " upload failed" );
        }
    }

    private long getTimeMillis(String strTime) {
        try {
            Date d = mSdf.parse(strTime);
            return d.getTime();
        } catch (Throwable e) {
            PushLog.inst().log(TAG + " getTimeMills error" );
        }
        return 0;
    }

    private void reportCommonLog(String data) {
        if (mLogImpl != null) {
            mLogImpl.reportCommonLog(YunLogConfig.NORMAL_URL, data);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        mLogImpl = null;
    }
}
