package com.yy.pushsvc.yunlog.weaknetlog;

import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;

import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.util.PushLog;

import java.io.File;
import java.io.FileWriter;

/**
 * Created by xudadade on 2019/1/14
 */
public class LogCacheService {
    private static String TAG = "LogCacheService";
    public static Object mLock = new Object();
    private static LogCacheService mInstance = null;
    private static final long UPLOAD_INTERVAL = 30 * 60 * 1000;
    private String LOG_CACHE_FILE_ROOT;
    private String LOG_CACHE_FILE_PATH;
    private String LOG_FILE_NAME;
    private String LOG_FILE_COPY_NAME;
    private HandlerThread thread = null;
    private Handler mLogHandler = null;
    private Looper mLooper = null;
    private Context mContext;

    private static int MESSAGE_TYPE_YUNLOG = 1;
    private static int MESSAGE_TYPE_UPLOAD = 2;

    public synchronized static LogCacheService getInstance() {
        if (mInstance == null) {
            mInstance = new LogCacheService();
        }
        return mInstance;
    }

    private LogCacheService() {
    }

    public String getFailPath() {
        return LOG_FILE_NAME;
    }

    public String getFailCopyPath() {
        return LOG_FILE_COPY_NAME;
    }

    public void init(Context context) {
        mContext = context;
        if (mContext != null) {
            LOG_CACHE_FILE_ROOT = mContext.getExternalFilesDir(null) + "/pushsdk/";
            LOG_CACHE_FILE_PATH = LOG_CACHE_FILE_ROOT + "CacheLog/";
            LOG_FILE_NAME = LOG_CACHE_FILE_PATH + "aliyunfaillog.txt";
            LOG_FILE_COPY_NAME = LOG_CACHE_FILE_PATH + "aliyunfaillog_copy.txt";
        }
        thread = new HandlerThread("LogCacheService");
        thread.start();
        mLooper = thread.getLooper();
        mLogHandler = new LogCacheHandler(mLooper);
        startUpload();
    }

    private void createLogFile() {
        File file = null;
        try {
            file = new File(LOG_FILE_NAME);
            if (file.exists()) {
                return;
            } else {
                File rootFile = new File(LOG_CACHE_FILE_ROOT);
                if (!rootFile.exists()) {
                    rootFile.mkdir();
                }
                File tempFile = new File(LOG_CACHE_FILE_PATH);
                if (!tempFile.exists()) {
                    tempFile.mkdir();
                }
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + "  " + e.toString());
        }
    }

    private final class LogCacheHandler extends Handler {
        LogCacheHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            if (msg.what == MESSAGE_TYPE_YUNLOG) {
                try {
                    writeToFile((String) msg.obj);
                } catch (Throwable e) {
                    PushLog.inst().log(TAG + "  handlerMessage error");
                }

            } else if (msg.what == MESSAGE_TYPE_UPLOAD) {
                startUpload();
            }
        }
    }

    public void sendMessage(String data) {
        if (mLogHandler != null) {
            Message message = Message.obtain();
            if (message != null) {
                message.what = MESSAGE_TYPE_YUNLOG;
                message.obj = data;

                mLogHandler.sendMessage(message);
            }
        }
    }

    private void writeToFile(String data) {
        synchronized (mLock) {
            FileWriter writer = null;
            try {
                createLogFile();
                writer = new FileWriter(LOG_FILE_NAME, true);
                writer.write(data);
                writer.write("\r\n");
                writer.flush();
            } catch (Throwable e) {
                PushLog.inst().log(TAG + "  writeToFile = null");
            } finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                } catch (Throwable e) {
                    PushLog.inst().log(TAG + "  writeToFile error");
                }

            }
        }
    }

    public void startUpload() {
        mLogHandler.removeMessages(MESSAGE_TYPE_UPLOAD);
        sendIntent();
        mLogHandler.sendEmptyMessageDelayed(MESSAGE_TYPE_UPLOAD, UPLOAD_INTERVAL);
    }

    private void sendIntent() {
        try {
            Context context = YYPush.getInstace().getContext();
            Intent intent = new Intent(context, LogUploadService.class);
            context.startService(intent);
        } catch (Throwable e) {
            PushLog.inst().log(TAG + "  sendIntent failed");
        }
    }
}
