package com.yy.pushsvc.yunlog.aliyun;

import android.annotation.SuppressLint;
import android.os.Build;
import android.util.Log;

import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.util.AppPackageUtil;
import com.yy.pushsvc.util.NetUtil;
import com.yy.pushsvc.yunlog.ILogConfig;

import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

/**
 * Created by qiushunming
 * 阿里云日志 配置
 */
public class YunLogConfig implements ILogConfig {
    private static final String TAG = "YunLogConfig";
    private static final String SCODE = "50279";
    private static final String APP_NAME = "PushSdk-android";
    private static final String PLAT = "android";
    private static final String DATA_TYPE_JSON = "0";

    public static final String NORMAL_URL = "http://log.sysop.duowan.com/normal/index.php";

    @SuppressLint("SimpleDateFormat")
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);

    @SuppressLint("SimpleDateFormat")
    private SimpleDateFormat beijenDataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);

    private Map<String, Object> mData = new HashMap<>();

    YunLogConfig() {
        beijenDataFormat.setTimeZone(TimeZone.getTimeZone("GMT+08:00"));
        mData.put("scode", SCODE);
        mData.put("app", APP_NAME);
        mData.put("devId", DeviceProxy.getHdid(YYPush.getInstace().getContext()));
        mData.put("model", Build.MODEL);
        mData.put("plat", PLAT);
        mData.put("datatype", DATA_TYPE_JSON);
        mData.put("ver", AppPushInfo.getYYPushVersion(YYPush.getInstace().getContext()));
        mData.put("osVer", Build.VERSION.RELEASE);
        mData.put("rev1",AppPackageUtil.getAppVersionName()+"&&"+AppPackageUtil.getAppVersionCode());//app
        // 的versionName+versionCode
    }

    @Override
    public String formatLog(String uid, String jsonValue) {

        JSONObject jsonObject = new JSONObject(mData);
        try {
            jsonObject.put("net", getNet());
            jsonObject.put("time", formatTime());
            jsonObject.put("beijinTime", formatBeiJinTime());
            jsonObject.put("uid", uid);
            jsonObject.put("info", jsonValue);
        } catch (Throwable e) {
            Log.i(TAG, "formatLog error e=" + e.toString());
        }

        return jsonObject.toString();
    }

    private String formatTime() {
        return dateFormat.format(new Date());
    }

    private String formatBeiJinTime() {
        return beijenDataFormat.format(new Date());
    }

    private String getNet() {

        String netStr = "unknow";
        @SuppressLint("MissingPermission")
        int net = NetUtil.getNetWorkType(YYPush.getInstace().getContext());
        switch (net) {
            case NetUtil.NETWORK_4G:
                netStr = "4g";
                break;
            case NetUtil.NETWORK_3G:
                netStr = "3g";
                break;
            case NetUtil.NETWORK_2G:
                netStr = "2g";
                break;
            case NetUtil.NETWORK_WIFI:
                netStr = "wifi";
                break;
            case NetUtil.NETWORK_NULL:
                netStr = "null";
                break;
            default:
                netStr = "unknow";
                break;
        }
        return netStr;
    }
}
