package com.yy.pushsvc.yunlog.aliyun;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;

import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.util.PushHttpUtil;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.yunlog.ILogConfig;
import com.yy.pushsvc.yunlog.IYunLog;
import com.yy.pushsvc.yunlog.weaknetlog.LogCacheService;

import java.io.IOException;
import java.net.URLEncoder;

/**
 * create by qiushunming
 */
public class AliYunLogImpl implements IYunLog {
    private static final String TAG = "AliYunLogImpl";

    private ILogConfig mLogConfig;

    private LogCacheService mLogCacheService;

    public AliYunLogImpl(Context context) {
        mLogConfig = new YunLogConfig();
        setConfig(mLogConfig);
        mLogCacheService =  LogCacheService.getInstance();
        mLogCacheService.init(context);
    }

    public ILogConfig getLogConfig() {
        return mLogConfig;
    }

    public void setConfig(ILogConfig config) {
        if (isConfigValid()) {
            return;
        }
        mLogConfig = config;
    }

    @Override
    public void pushNormal(String uid, String info) {
        if (isConfigValid()) {
            String data = mLogConfig.formatLog(uid, info);
            reportCommonLog(YunLogConfig.NORMAL_URL, data);
        } else {
            Log.e(TAG, "mLogConfig is invalid", null);
        }
    }

    private boolean isConfigValid() {
        if (mLogConfig == null) {
            return false;
        }
        return true;
    }

    public void reportCommonLog(String url, String data) {
        PushThreadPool.getPool().execute(new Runnable() {
            @Override
            public void run() {
                try {
                    String encodeStr ="data="+ URLEncoder.encode(data, "UTF-8");
                    PushHttpUtil.PushHttpResp resp =
                            PushHttpUtil
                                    .postHttp(url,encodeStr,
                                            !TextUtils.isEmpty(AppPushInfo.getPushTestEnvIp()));
                    Log.i(TAG, "statusCode = " + resp.statusCode);
                    if (resp.statusCode == 200) {
                        Log.d(TAG, "respone = " + resp.toString() + " body=" + resp.result);
                    } else {
                        if (mLogCacheService != null) {
                            mLogCacheService.sendMessage(data);
                        }
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

}
