package com.yy.pushsvc.yunlog;

import android.content.Context;
import android.util.Log;

import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.pushsvc.BuildConfig;
import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.util.AppPackageUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.yunlog.aliyun.AliYunLogImpl;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Klog + 阿里云log封装
 */
public class KLogW {
    private static volatile IYunLog mYunLog ;
    private static boolean mOpen = false;
    private static Context mContext;

    public static IYunLog getYunLogImpl() {
        try {
            if (mYunLog == null) {
                synchronized (KLogW.class) {
                    if (mYunLog == null) {
                        if (mContext == null) {
                            mContext = YYPush.getInstace().getContext();
                        }
                        mYunLog = new AliYunLogImpl(mContext);
                    }
                }
            }
        } catch (Throwable t) {
            Log.i("getYunLogImpl", t.toString());
        }
        return mYunLog;
    }

    public static void init(Context context){
        mContext = context;
    }

    public static void setYunlogOpen(boolean open){
        mOpen = open;
    }

    public static void i(String tag, String format, Object... args) {
        try {
            if (mOpen) {
                String yunlog = getYunLog(tag, format, args);
                String uid = getUid();
                getYunLogImpl().pushNormal(uid, yunlog);
            }
        } catch (Throwable t) {
            PushLog.inst().log("KLogW" + ",i,erro = " + t);
        }
    }

    private static String getYunLog(String tag, String format, Object... args) {
        JSONObject jsonObject = new JSONObject();
        try {
            String info = String.format(format, args);
            jsonObject.put("event", tag);
            jsonObject.put("hdid", DeviceProxy.getHdid(YYPush.getInstace().getContext()));
            jsonObject.put("appKey", Integer.toString(AppPackageUtil.getAppKey(YYPush.getInstace().getContext())));
            jsonObject.put("log", info);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject.toString();
    }

    private static String getUid() {
        long uid =  TokenStore.getInstance().getBindAccount();
        return String.valueOf(uid);
    }
}
