package com.yy.pushsvc.util;

import java.util.Calendar;
import java.util.IllegalFormatException;

/**
 * Created by Zhanghuiping on 14/6/5.
 */

public class TimeUtils {

    /**
     * @param millis time in millis
     * @return hour of 24-hour clock
     */
    public static int getHourOf24HClock(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(Calendar.HOUR_OF_DAY);
    }

    public static int getMinute(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(Calendar.MINUTE);
    }

    /**
     * @param timeMillis time in millis
     * @param format     format string, must contain 6 args: year, month, day, hour, minute, second
     * @return format time string
     */
    public static String getTimeStringFromMillis(long timeMillis, String format) {
        if (format == null || format.length() == 0) {
            return null;
        }
        final Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeMillis);
        int year = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH) + 1;
        int day = cal.get(Calendar.DAY_OF_MONTH);
        int hour = cal.get(Calendar.HOUR_OF_DAY);
        int min = cal.get(Calendar.MINUTE);
        int sec = cal.get(Calendar.SECOND);
        String timeString = null;
        try {
            timeString = String.format(format, year, month, day, hour, min, sec);
        } catch (IllegalFormatException e) {
            android.util.Log.e("TimeUtils", "printStackTrace", e);
        }
        return timeString;
    }

    /**
     * 将毫秒时间转换为指定的字符串格式,例如传入format“year-mon-day”,返回类似“2014-08-29”
     *
     * @param timeMillis
     * @param format     year,mon,day,hour,min,sec
     * @return 指定时间格式
     */
    public static String getFormatTimeString(long timeMillis, String format) {
        if (format == null || format.length() == 0) {
            return null;
        }
        final Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeMillis);
        int year = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH) + 1;
        int day = cal.get(Calendar.DAY_OF_MONTH);
        int hour = cal.get(Calendar.HOUR_OF_DAY);
        int min = cal.get(Calendar.MINUTE);
        int sec = cal.get(Calendar.SECOND);
        String timeString = null;
        try {
//            timeString = String.format(format, year, month, day, hour, min, sec);
            timeString = format.replaceAll("year", String.valueOf(year))
                    .replaceAll("mon", month < 10 ? "0" + month : "" + month)
                    .replaceAll("day", day < 10 ? "0" + day : "" + day)
                    .replaceAll("hour", hour < 10 ? "0" + hour : "" + hour)
                    .replaceAll("min", min < 10 ? "0" + min : "" + min)
                    .replaceAll("sec", sec < 10 ? "0" + sec : "" + sec);
        } catch (Throwable e) {
            PushLog.inst().log("getFormatTimeString," + e);
        }
        return timeString;
    }
}
