package com.yy.pushsvc.util;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;

import java.io.BufferedReader;
import java.io.InputStreamReader;

/**
 * Created by HUTAO on 2017/12/5.
 */

public class SystemUtil {

    public static boolean isXiaoMi() {
        return Build.MANUFACTURER != null &&
                Build.MANUFACTURER.equalsIgnoreCase("Xiaomi");
    }

    public static boolean isMiUi() {
        try {
            String ret = AppPackageUtil.getSystemProperty(YYPushConsts.KEY_MIUI_VERSION_NAME);
            if (!TextUtils.isEmpty(ret)) {
                return true;
            }
        } catch (Exception e) {
            Log.e("SystemUtil", "isMiUi exception:" + e);
            return isXiaoMi();
        }
        return false;
    }

    public static boolean isHuaWei() {
        return Build.MANUFACTURER != null &&
                (Build.MANUFACTURER.equalsIgnoreCase("HUAWEI") ||
                        Build.MANUFACTURER.equalsIgnoreCase("honor"));
    }

    public static boolean isOppo() {
        return Build.MANUFACTURER != null &&
                (Build.MANUFACTURER.equalsIgnoreCase("OPPO") );
    }
}
