package com.yy.pushsvc.util;

import android.app.Activity;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static String IpAddress = "";

    public static byte[] hexStringConvert(final byte[] strHex) {
        byte[] strBin = new byte[strHex.length];
        byte finalByte = 0;
        boolean bHi = true;
        int i = 0; //hex
        int j = 0; //bin
        while (i < strHex.length) {
            int v;
            byte c = strHex[i];
            if (c >= '0' && c <= '9') {
                v = c - '0';
            } else if (c >= 'a' && c <= 'z') {
                v = c - 'a' + 10;
            } else if (c >= 'A' && c <= 'Z') {
                v = c - 'A' + 10;
            } else {
                i++;
                continue;
            }

            if (bHi) {
                finalByte = (byte) (v << 4);
                bHi = false;
            } else {
                finalByte |= (v & 0xf);
                bHi = true;
                strBin[j] = (byte) (finalByte & 0xff);
                j++;
                finalByte = 0;
            }
            i++;
        }
        byte[] strFinal = new byte[j];
        for (int index = 0; index < j; ++index) {
            strFinal[index] = strBin[index];
        }
        return strFinal;
    }

    private static String removeAll(String ip) { //去掉IP字符串中的空格、回车、换行、制表符
        String dest = "";
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(ip);
        dest = m.replaceAll("");
        return dest;
    }

    public static boolean isIp(String ip) { //判断是否是一个IP
        try {
            ip = removeAll(ip);
            if (ip.matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")) {
                String[] s = ip.split("\\.");
                if (Integer.parseInt(s[0]) <= 255
                        && Integer.parseInt(s[1]) <= 255
                        && Integer.parseInt(s[2]) <= 255
                        && Integer.parseInt(s[3]) <= 255) {
                    return true;
                }
            }
            return false;
        } catch (Exception e) {
            return false;
        }

    }

    public static boolean isDomain(String host) {
        if (IpAddress.equals("")) {
            InetAddress inetAddress;
            try {
                if (host != null && !host.equals("")) {
                    inetAddress = InetAddress.getByName(host);
                    IpAddress = inetAddress.getHostAddress();
                    if (isIp(IpAddress)) {
                        PushLog.inst().log("StringUtil.isDomain IpAddress:" + IpAddress + " is ip");
                        return true;
                    } else {
                        PushLog.inst().log("StringUtil.isDomain IpAddress:" + IpAddress + " is not ip");
                        return false;
                    }
                } else {
                    PushLog.inst().log("StringUtil.isDomain is not domain");
                    return false;
                }
            } catch (UnknownHostException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.equals("");
    }

    public static String exception2String(Exception e) {
        if (e == null) {
            return "";
        }
        String str = e.toString();
        if (str == null) {
            return "";
        } else {
            return str;
        }
    }

    public static String inStream2String(InputStream is) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int len = -1;
        while ((len = is.read(buf)) != -1) {
            baos.write(buf, 0, len);
        }
        is.close();
        byte[] data = baos.toByteArray();
        baos.close();
        return new String(data);
    }
}
