package com.yy.pushsvc.util;

import android.os.SystemClock;

import java.text.SimpleDateFormat;
import java.util.Date;

public class PushTimeCalculator {

    private static PushTimeCalculator mInstance = null;
    private Long mCalculatedTime = 0L;

    public static PushTimeCalculator getInstance() {
        if (mInstance == null) {
            mInstance = new PushTimeCalculator();
        }
        return mInstance;
    }

    private PushTimeCalculator() {
        //初始化为本地时间，避免在时间同步前，用户修改本地时间导致每次获取时间差异太大
        setCurrentSrvTime(System.currentTimeMillis());
    }

    public void setCurrentSrvTime(long srvTime) {
        synchronized (mCalculatedTime) {
            mCalculatedTime = srvTime - System.nanoTime() / 1000000;
        }
    }

    private long currentTimeMillis() {
        synchronized (mCalculatedTime) {
            return System.nanoTime() / 1000000 + mCalculatedTime;
        }
    }

    public static long getCurrentTimeMillis() {
        return PushTimeCalculator.getInstance().currentTimeMillis();
    }

    public static long getCurrentTimeSecond() {
        return getCurrentTimeMillis() / 1000;
    }

    public static String secondToDate(long second) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(second * 1000));
        } catch (Exception e) {
            return "null";
        }
    }

    public static String millisToDate(long millis) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(millis));
        } catch (Exception e) {
            return "null";
        }
    }

    public static long getNanoSecond() {
        return System.nanoTime() / 1000000000;
    }

    public static long getSystemElapsedSecond() {
        return SystemClock.elapsedRealtime() / 1000;
    }
}
