package com.yy.pushsvc.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.preference.PreferenceManager;
import android.util.Log;

import com.yy.pushsvc.YYPush;

public class PushSPHelper {
    private final static String TAG = "PushSPHelper";
    private final static String CONF_PUSH_ENV = "conf_push_env";
    private final static String CONF_PUSH_LOG_ENCRYPT = "conf_push_log_encrypt";
    private final static String CONF_PUSH_LOG_DEBUG   = "conf_push_log_debug";
    private final static String CONF_PUSH_LOG_PATH    = "conf_push_log_path";
    private final static String CONF_PUSH_EXT_REPORT  = "conf_push_ext_report";
    private final static String CONF_PUSH_PERMISSION_REPORT  = "conf_push_permission_report";
    private final static String CONF_PUSH_PERMISSION  = "conf_push_permission";
    private final static String CONF_PUSH_URL_DOMAIN  = "conf_push_url_domain";

    private static PushSPHelper pushConfig;

    public static PushSPHelper getInstance() {
        if (pushConfig == null) {
            pushConfig = new PushSPHelper();
        }
        return pushConfig;
    }

    private static SharedPreferences getSharedPreferences(Context context) {
        return PreferenceManager.getDefaultSharedPreferences(context);
    }

    public String getConfPushLogPath(Context context, String def) {

        try {
            return getSharedPreferences(context).getString(CONF_PUSH_LOG_PATH, def);
        } catch (Throwable e) {
            return def;
        }
    }

    public void setConfPushLogPath(Context context, String v) {
        try {
            Editor editor = getSharedPreferences(context).edit();
            editor.putString(CONF_PUSH_LOG_PATH, v);
            editor.apply();
        } catch (Throwable e) {
            Log.e(TAG, "setConfPushLogPath: ", e);
        }
    }

    public boolean getConfPushExtReport(Context context) {
        try {
            return getSharedPreferences(context).getInt(CONF_PUSH_EXT_REPORT, 0) == 1;
        } catch (Throwable e) {
            return false;
        }
    }

    public void setConfPushExtReport(Context context, int v) {
        try {
            Editor editor = getSharedPreferences(context).edit();
            editor.putInt(CONF_PUSH_EXT_REPORT, v);
            editor.apply();
        } catch (Throwable e) {
            Log.e(TAG, "setConfPushExtReport: ", e);
        }
    }

    public int getConfPushEnv(Context context) {
        try {
            return getSharedPreferences(context).getInt(CONF_PUSH_ENV, 0);
        } catch (Throwable e) {
            return 0;
        }
    }

    public void setConfPushEnv(Context context, int v) {
        try {
            Editor editor = getSharedPreferences(context).edit();
            editor.putInt(CONF_PUSH_ENV, v);
            editor.apply();
        } catch (Throwable e) {
            Log.e(TAG, "setConfPushEnv: ", e);
        }
    }

    public void setConfPushLogEncrypt(Context context, boolean v) {
        try {
            Editor editor = getSharedPreferences(context).edit();
            editor.putInt(CONF_PUSH_LOG_ENCRYPT, v? 1 : 0);
            editor.apply();
        } catch (Throwable e) {
            Log.e(TAG, "setConfPushLogEncrypt: ", e);
        }
    }

    public void setConfPushLogDebug(Context context, boolean v) {
        try {
            Editor editor = getSharedPreferences(context).edit();
            editor.putInt(CONF_PUSH_LOG_DEBUG, v? 1 : 0);
            editor.apply();
        } catch (Throwable e) {
            Log.e(TAG, "setConfPushLogDebug: ", e);
        }
    }

    public boolean getConfPushLogEncrypt(Context context) {
        try {
            int i = getSharedPreferences(context).getInt(CONF_PUSH_LOG_ENCRYPT, 0);
            return i == 1;
        } catch (Throwable e) {
            return false;
        }
    }

    public boolean getConfPushLogDebug(Context context) {
        try {
            int i = getSharedPreferences(context).getInt(CONF_PUSH_LOG_DEBUG, 1);
            return i == 1;
        } catch (Throwable e) {
            return false;
        }
    }

    public long getConfPushPermissionRreportTime(Context context) {
        try {
            return getSharedPreferences(context).getLong(CONF_PUSH_PERMISSION_REPORT, 0L);
        } catch (Throwable e) {
            return 0L;
        }
    }

    public void setConfPushPermissionReport(Context context, long v) {
        try {
            Log.d(TAG, "setConfPushPermissionReport: " + v);
            Editor editor = getSharedPreferences(context).edit();
            editor.putLong(CONF_PUSH_PERMISSION_REPORT, v);
            editor.apply();
        } catch (Throwable e) {
            Log.e(TAG, "setConfPushPermissionReport: ", e);
        }
    }


    public int getConfPushPermission(Context context) {
        try {
            return getSharedPreferences(context).getInt(CONF_PUSH_PERMISSION, 0);
        } catch (Throwable e) {
            return 0;
        }
    }

    public void setConfPushPermission(Context context, int v) {
        try {
            Log.d(TAG, "setConfPushPermission: " + v);
            Editor editor = getSharedPreferences(context).edit();
            editor.putInt(CONF_PUSH_PERMISSION, v);
            editor.apply();
        } catch (Throwable e) {
            Log.e(TAG, "setConfPushPermission: ", e);
        }
    }

    public String getConfUrlDomain(Context context) {
        try {
            return getSharedPreferences(context).getString(CONF_PUSH_URL_DOMAIN, YYPush.httpsDNS);
        } catch (Throwable e) {
            return YYPush.httpsDNS;
        }
    }

    public void setConfUrlDomain(Context context, String v) {
        try {
            Log.d(TAG, "setConfUrlDomain: " + v);
            Editor editor = getSharedPreferences(context).edit();
            editor.putString(CONF_PUSH_URL_DOMAIN, v);
            editor.apply();
        } catch (Throwable e) {
            Log.e(TAG, "setConfUrlDomain: ", e);
        }
    }
}
