package com.yy.pushsvc.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Process;
import android.util.Log;

import com.yy.pushsvc.log.ILogHandler;
import com.yy.pushsvc.log.LogConfig;
import com.yy.pushsvc.log.LogcatHandler;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;

public class PushLog implements Runnable {
    private static PushLog inst = null;
    public BlockingDeque<String> deque = new LinkedBlockingDeque<>();
    private ILogHandler logHandler = null;
    private SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private LogConfig logConfig = new LogConfig();

    private PushLog() {
        PushThreadPool.getPool().execute(this);
    }

    public static PushLog inst() {
        if (inst == null) {
            synchronized (PushLog.class) {
                if (inst == null) {
                    inst = new PushLog();
                }
            }
        }
        return inst;
    }

    @Override
    public void run() {
        while (true) {
            String msg;
            try {
                msg = deque.take();
                logDispatch(msg);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @SuppressLint("SimpleDateFormat")
    public void log(String msg) {
        try {
            msg = "[" + Process.myPid() + ":" + Process.myTid() + "]" + msg;
            deque.add(msg);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized void logDispatch(String msg) {
        if (logHandler == null) {
            Log.e("PushLog", "logDispatch logHandler is Null,msg = " + msg);
            return;
        }
        String msgToLog =
                dateformat.format(new Date(PushTimeCalculator.getCurrentTimeMillis())) + " " +
                        logConfig.getTag() + " " + msg +
                        "\n";
        logHandler.i(msgToLog);
    }

    public void setupLogDir(String dir) {
        logConfig.setLogDir(dir);
    }

    public String getLogPath() {
        return logConfig.getLogDir();
    }

    public void setTag(String tag) {
        if (tag != null) {
            logConfig.setTag("[" + tag + "]");
        }
    }

    public void setLogHandler(ILogHandler logHandler) {
        this.logHandler = logHandler;
    }

    public void init(Context context) {
        if (logHandler == null) {
            logHandler = new LogcatHandler(logConfig);
        }
    }

}
