package com.yy.pushsvc.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/**
 * Created by maxiaodong on 2018/10/19.
 * Description http封装类
 */

public class PushHttpUtil {
    private static final String TAG = "PushHttpUtil";
    private static final int CONNECT_TIMEOUT_LONG = 10000;
    private static final int READ_TIMEOUT_LONG = 30000;

    public static class PushHttpResp {
        public boolean isSucceed = false;
        public int statusCode = -1;
        public String reason = null;
        public String result = null;

        public PushHttpResp() {
        }
    }

    public PushHttpUtil() {
    }

    public synchronized static PushHttpResp post(String httpUrl, String content, boolean isTestEnv) throws IOException {
        PushLog.inst().log(TAG + ".post start post data," + "isTestEnv=" + isTestEnv + ",httpUrl=" +
                httpUrl + "," +
                "content=" + content);
        PushHttpResp resp = new PushHttpResp();
        URL url;
        HttpsURLConnection urlConnection = null;
        InputStream ins = null;
        try {
            url = new URL(httpUrl);
            urlConnection = (HttpsURLConnection) url.openConnection();
            if (isTestEnv) {
                trustAllHosts(urlConnection);
            }
            urlConnection.setRequestMethod("POST");
            urlConnection.setConnectTimeout(CONNECT_TIMEOUT_LONG);
            urlConnection.setReadTimeout(READ_TIMEOUT_LONG);
            urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            urlConnection.setRequestProperty("User-Agent", "HttpUrlConnection/Android");
            urlConnection.connect();
            OutputStream os = urlConnection.getOutputStream();
            os.write(content.getBytes("UTF-8"));
            os.flush();
            os.close();
            resp.isSucceed = urlConnection.getResponseCode() == 200;
            resp.statusCode = urlConnection.getResponseCode();
            resp.reason = urlConnection.getResponseMessage();
            if (urlConnection.getResponseCode() == 200) {
                PushLog.inst().log(TAG + ".post data succeed statusCode:" + urlConnection.getResponseCode());
                ins = urlConnection.getInputStream();
                resp.result = StringUtil.inStream2String(ins);
                ins.close();
                ins = null;
            } else {
                PushLog.inst().log(TAG + ".post data failed statusCode:" + urlConnection.getResponseCode());
            }
        } catch (Exception e) {
            PushLog.inst().log(TAG + ".post data exception:" + e.toString());
            resp.reason = resp.reason + " " + e.toString();
        } finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            if (ins != null) {
                ins.close();
            }
        }
        return resp;
    }

    private static void trustAllHosts(HttpsURLConnection httpsURLConnection) {
        try {
            PushLog.inst().log(TAG + ".trustAllHosts");
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new X509TrustManager() {
                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {

                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {

                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            } }, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sc.getSocketFactory();
            httpsURLConnection.setSSLSocketFactory(sslSocketFactory);
            httpsURLConnection.setHostnameVerifier(new HostnameVerifier() {
                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized static PushHttpResp getModle(String httpUrl, boolean isTestEnv)
            throws IOException {
        PushLog.inst().log(TAG + ".post start post data," + "isTestEnv=" + isTestEnv + ",httpUrl=" +
                httpUrl );
        PushHttpResp resp = new PushHttpResp();
        URL url;
        HttpsURLConnection urlConnection = null;
        InputStream ins = null;
        try {
            url = new URL(httpUrl);
            urlConnection = (HttpsURLConnection) url.openConnection();
            if (isTestEnv) {
                trustAllHosts(urlConnection);
            }
            urlConnection.setRequestMethod("GET");
            urlConnection.setConnectTimeout(CONNECT_TIMEOUT_LONG);
            urlConnection.setReadTimeout(READ_TIMEOUT_LONG);
            // urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setRequestProperty("Content-type", "application/json");
            urlConnection.setRequestProperty("User-Agent", "HttpUrlConnection/Android");
            urlConnection.connect();
            resp.isSucceed = urlConnection.getResponseCode() == 200;
            resp.statusCode = urlConnection.getResponseCode();
            resp.reason = urlConnection.getResponseMessage();
            if (urlConnection.getResponseCode() == 200) {
                PushLog.inst().log(TAG + ".post data succeed statusCode:" + urlConnection.getResponseCode());
                ins = urlConnection.getInputStream();
                resp.result = StringUtil.inStream2String(ins);
                ins.close();
                ins = null;
            } else {
                PushLog.inst().log(TAG + ".post data failed statusCode:" + urlConnection.getResponseCode());
            }
        } catch (Exception e) {
            PushLog.inst().log(TAG + ".post data exception:" + e.toString());
            resp.reason = resp.reason + " " + e.toString();
        } finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            if (ins != null) {
                ins.close();
            }
        }
        return resp;
    }

    public synchronized static PushHttpResp getTemplateJson(String httpUrl, boolean isTestEnv)
            throws IOException {
        PushLog.inst().log(TAG + ".post start post data," + "isTestEnv=" + isTestEnv + ",httpUrl=" +
                httpUrl );
        PushHttpResp resp = new PushHttpResp();
        URL url;
        HttpsURLConnection urlConnection = null;
        try {
            url = new URL(httpUrl);
            urlConnection = (HttpsURLConnection) url.openConnection();
            if (isTestEnv) {
                trustAllHosts(urlConnection);
            }
            urlConnection.setRequestMethod("GET");
            urlConnection.setConnectTimeout(CONNECT_TIMEOUT_LONG);
            urlConnection.setReadTimeout(READ_TIMEOUT_LONG);
            urlConnection.setUseCaches(false);
            urlConnection.setRequestProperty("Charset", "UTF-8");
            urlConnection.setRequestProperty("User-Agent", "HttpUrlConnection/Android");
            urlConnection.connect();
            BufferedInputStream bin = new BufferedInputStream(urlConnection.getInputStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int size = 0;
            byte[] buf = new byte[1024];
            while ((size = bin.read(buf)) != -1) {
                out.write(buf, 0, size);
            }
            String strJson = new String(out.toByteArray(), "UTF-8");
            resp.result = strJson;
            bin.close();
            out.close();
        } catch (Exception e) {
            PushLog.inst().log(TAG + ".post data exception:" + e.toString());
            resp.reason = resp.reason + " " + e.toString();
        } finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return resp;
    }

    public synchronized static PushHttpResp postHttp(String httpUrl, String content, boolean isTestEnv) throws IOException {
        PushLog.inst().log(TAG + ".post start post data," + "isTestEnv=" + isTestEnv + ",httpUrl=" +
                httpUrl + "," +
                "content=" + content);
        PushHttpResp resp = new PushHttpResp();
        URL url;
        HttpURLConnection urlConnection = null;
        InputStream ins = null;
        try {
            url = new URL(httpUrl);
            urlConnection = (HttpURLConnection) url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setConnectTimeout(CONNECT_TIMEOUT_LONG);
            urlConnection.setReadTimeout(READ_TIMEOUT_LONG);
            urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            urlConnection.setRequestProperty("User-Agent", "HttpUrlConnection/Android");
            urlConnection.connect();
            OutputStream os = urlConnection.getOutputStream();
            os.write(content.getBytes("UTF-8"));
            os.flush();
            os.close();
            resp.isSucceed = urlConnection.getResponseCode() == 200;
            resp.statusCode = urlConnection.getResponseCode();
            resp.reason = urlConnection.getResponseMessage();
            if (urlConnection.getResponseCode() == 200) {
                PushLog.inst().log(TAG + ".post data succeed statusCode:" + urlConnection.getResponseCode());
                ins = urlConnection.getInputStream();
                resp.result = StringUtil.inStream2String(ins);
                ins.close();
                ins = null;
            } else {
                PushLog.inst().log(TAG + ".post data failed statusCode:" + urlConnection.getResponseCode());
            }
        } catch (Exception e) {
            PushLog.inst().log(TAG + ".post data exception:" + e.toString());
            resp.reason = resp.reason + " " + e.toString();
        } finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            if (ins != null) {
                ins.close();
            }
        }
        return resp;
    }

}
