package com.yy.pushsvc.util;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;

import com.yy.pushsvc.YYPush;

import java.io.File;
import java.io.IOException;

public class PushFileHelper {
    private static final String TAG = "PushFileHelper";
    private Context mContext = null;
    private String mPkgName = null;

    private String pushDir = null;
    private String pushDirLog = null;
    private String pushFileConfigPath = null;

    private volatile boolean mInit = false;

    private static PushFileHelper mInstance = null;

    private PushFileHelper() {
    }

    public static PushFileHelper instance() {
        if (mInstance == null) {
            mInstance = new PushFileHelper();
        }
        return mInstance;
    }

    public void init(Context context) {
        if (context == null) {
            if (YYPush.getInstace().getContext() != null) {
                context = YYPush.getInstace().getContext();
            }
        }
        if (context == null || mInit) {
            return;
        }
        mContext = context;
        mPkgName = mContext.getPackageName();
        pushDir = context.getExternalFilesDir(null) + File.separator +
                YYPushConsts.getPushIdentification();
        pushDirLog = pushDir + "/log";
        pushFileConfigPath = pushDir + "/config/LogPath.txt";
        if (!mkdir(pushDir) || !mkdir(pushDirLog)) {
            return;
        }

        if (!createFile(pushFileConfigPath)) {
            return;
        }
        mInit = mPkgName != null;
    }

    public String getPushDir(Context context) {
        try {
            if (mContext == null) {
                mContext = context;
            }
            if (!TextUtils.isEmpty(pushDir)) {
                return pushDir;
            } else {
                pushDir = context.getExternalFilesDir(null) + File.separator +
                        YYPushConsts.getPushIdentification();
                return pushDir;
            }
        } catch (Throwable t) {
            Log.i(TAG, "getPushDir,erro = " + t);
        }
        return pushDir;
    }

    private boolean mkdir(String dir) {
        File pushLogDir = new File(dir);
        if (!pushLogDir.exists()) {
            pushLogDir.mkdirs();
            if (!pushLogDir.exists()) {
                return false;
            }
        }
        return true;
    }

    public boolean createFile(String file) {
        File logTmpFile = new File(file);
        if (!logTmpFile.exists()) {
            try {
                mkdir(logTmpFile.getParent());
                logTmpFile.createNewFile();
                return logTmpFile.exists();
            } catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        } else {
            return true;
        }
    }

    public String getPushLogDir() {
        return pushDirLog;
    }

    public String getPushLogConfigFilePath() {
        return pushFileConfigPath;
    }
}
