package com.yy.pushsvc.util;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.provider.Settings;
import android.util.Log;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import androidx.core.app.NotificationManagerCompat;

/**
 * Created by GuanYuFeng
 * on 2019/11/8
 */
public class NotificationUtil {
    private static Context mContext;
    private static List<Integer> delayList = new ArrayList<>();
    private static Handler mainHandler = new Handler(Looper.getMainLooper()) {
        @Override
        public void handleMessage(Message msg) {
        }
    };

    public static void showNotificationDelay(Context context, int notificationId,
                                             Notification notification, long delayMillis) {
        mContext = context;
        if (!delayList.contains(notificationId)) {
            delayList.add(notificationId);
            mainHandler.sendEmptyMessageDelayed(100, delayMillis);
        }
    }

    public static void cancleNotification(Context context, int notificationId) {
        NotificationManager notificationManager =
                (NotificationManager) context
                        .getSystemService(Context.NOTIFICATION_SERVICE);
        notificationManager.cancel(notificationId);
    }

    public static void collapseStatusBar(Context context) {
        try {
            Object statusBarManager = context.getSystemService("statusbar");
            Method collapse;
            if (Build.VERSION.SDK_INT <= 16) {
                collapse = statusBarManager.getClass().getMethod("collapse");
            } else {
                collapse = statusBarManager.getClass().getMethod("collapsePanels");
            }
            collapse.setAccessible(true);
            collapse.invoke(statusBarManager);
        } catch (Throwable localException) {
            localException.printStackTrace();
        }
    }

    public static int createNotificationId(long messageId) {
        try {
            if (messageId >= Integer.MAX_VALUE) {
                return (int) (messageId % Integer.MAX_VALUE);
            } else {
                return (int) messageId;
            }
        } catch (Exception e) {
            return (int) messageId;
        }
    }

    public static boolean isAppIsInBackground(Context context) {
        boolean isInBackground = true;
        try {
            ActivityManager am =
                    (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
            if (am == null) {
                return false;
            }

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                List<ActivityManager.RunningAppProcessInfo> runningProcesses =
                        am.getRunningAppProcesses();
                if (runningProcesses != null) {
                    for (ActivityManager.RunningAppProcessInfo processInfo : runningProcesses) {
                        if (processInfo != null &&
                                processInfo.importance ==
                                        ActivityManager.RunningAppProcessInfo.IMPORTANCE_FOREGROUND) {
                            for (String activeProcess : processInfo.pkgList) {
                                if (activeProcess.equals(context.getPackageName())) {
                                    isInBackground = false;
                                }
                            }
                        }
                    }
                }
            } else {
                List<ActivityManager.RunningTaskInfo> taskInfo = am.getRunningTasks(1);
                if (taskInfo != null) {
                    if (taskInfo != null && taskInfo.size() > 0 && taskInfo.get(0) != null) {
                        ComponentName componentInfo = taskInfo.get(0).topActivity;
                        if (componentInfo != null &&
                                componentInfo.getPackageName().equals(context.getPackageName())) {
                            isInBackground = false;
                        }
                    }
                }
            }
        } catch (Throwable t) {
            PushLog.inst().log("isAppIsInBackground,erro=" + t);
        }

        return isInBackground;
    }

    public final static int MODE_FORBID = 0;
    public final static int MODE_ALLOWED = 1;
    public final static int MODE_NO_PERMISSION = 2;

    private static final String CHECK_OP_NO_THROW = "checkOpNoThrow";
    private static final String OP_POST_NOTIFICATION = "OP_POST_NOTIFICATION";

    private static volatile boolean sHasTest = false;
    private static volatile boolean sSsNotificationEnabled = false;

    @SuppressLint("NewApi")
    public static boolean isNotificationEnabled(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            NotificationManagerCompat manager = NotificationManagerCompat.from(context);
            return manager.areNotificationsEnabled();
        }
        if (Build.VERSION.SDK_INT <
                Build.VERSION_CODES.KITKAT) {
            // AppOpsManager在4.4的ROM才开始支持,4.4以下的默认返回获取了通知栏权限
            return true;
        }

        if (sHasTest) {
            return sSsNotificationEnabled;
        }

        sHasTest = true;
        /* Context.APP_OPS_MANAGER */
        try {
            ApplicationInfo appInfo = context.getApplicationInfo();
            String pkg = context.getApplicationContext().getPackageName();
            int uid = appInfo.uid;

            Class appOpsClass = null;

            appOpsClass = Class.forName(AppOpsManager.class.getName());
            Method checkOpNoThrowMethod =
                    appOpsClass.getMethod(CHECK_OP_NO_THROW, Integer.TYPE, Integer.TYPE,
                            String.class);
            Field opPostNotificationValue = appOpsClass.getDeclaredField(OP_POST_NOTIFICATION);

            int value = (Integer) opPostNotificationValue.get(Integer.class);
            sSsNotificationEnabled = ((Integer) checkOpNoThrowMethod
                    .invoke(context.getSystemService(Context.APP_OPS_SERVICE), value, uid, pkg) ==
                    AppOpsManager.MODE_ALLOWED);
            return sSsNotificationEnabled;
        } catch (Throwable e) {
            PushLog.inst().log("isNotificationEnabled," + e);
        }

        sSsNotificationEnabled = false;
        return sSsNotificationEnabled;
    }

    public static void resetHasTestFlag() {
        sHasTest = false;
    }

    /**
     * 查一下是否有这个通知栏权限
     *
     * @param context
     * @return
     */
    public static int getNotificationStatus(Context context) {

        try {
            ApplicationInfo appInfo = context.getApplicationInfo();
            String pkg = context.getApplicationContext().getPackageName();
            int uid = appInfo.uid; // NOSONAR
            Class appOpsClass = null; /* Context.APP_OPS_MANAGER */
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                appOpsClass = Class.forName(AppOpsManager.class.getName());
            }
            Method checkOpNoThrowMethod =
                    appOpsClass
                            .getMethod(CHECK_OP_NO_THROW, Integer.TYPE, Integer.TYPE, String.class);
            Field opPostNotificationValue = appOpsClass.getDeclaredField(OP_POST_NOTIFICATION);
            int value = (Integer) opPostNotificationValue.get(Integer.class);
            if (((Integer) checkOpNoThrowMethod
                    .invoke(context.getSystemService(Context.APP_OPS_SERVICE), value, uid, pkg) ==
                    AppOpsManager.MODE_ALLOWED)) {
                return MODE_ALLOWED;
            } else {
                return MODE_FORBID;
            }

        } catch (ClassNotFoundException e) {
            android.util.Log.e("NotificationsUtils", "printStackTrace", e);
        } catch (NoSuchMethodException e) {
            android.util.Log.e("NotificationsUtils", "printStackTrace", e);
        } catch (NoSuchFieldException e) {
            android.util.Log.e("NotificationsUtils", "printStackTrace", e);
        } catch (InvocationTargetException e) {
            android.util.Log.e("NotificationsUtils", "printStackTrace", e);
        } catch (IllegalAccessException e) {
            android.util.Log.e("NotificationsUtils", "printStackTrace", e);
        } catch (Throwable e) {
            android.util.Log.e("NotificationsUtils", "printStackTrace", e);
        }
        return MODE_NO_PERMISSION;
    }

    /**
     * 跳转到权限设置界面
     */
    public static void openNotificationSetting(Context context) {
        // vivo 点击设置图标>加速白名单>我的app
        //      点击软件管理>软件管理权限>软件>我的app>信任该软件
        Intent appIntent = context.getPackageManager().getLaunchIntentForPackage("com.iqoo.secure");
        if (appIntent != null) {
            context.startActivity(appIntent);
            return;
        }

        // oppo 点击设置图标>应用权限管理>按应用程序管理>我的app>我信任该应用
        //      点击权限隐私>自启动管理>我的app
        appIntent = context.getPackageManager().getLaunchIntentForPackage("com.oppo.safe");
        if (appIntent != null) {
            context.startActivity(appIntent);
            return;
        }

        Intent intent = new Intent();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            intent.setAction(Settings.ACTION_APP_NOTIFICATION_SETTINGS);
            intent.putExtra(Settings.EXTRA_APP_PACKAGE, context.getPackageName());
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            intent.setAction(Settings.ACTION_APP_NOTIFICATION_SETTINGS);
            intent.putExtra("app_package", context.getPackageName());
            intent.putExtra("app_uid", context.getApplicationInfo().uid);
        } else {
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            intent.setAction(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
            intent.setData(Uri.fromParts("package", context.getPackageName(), null));
        }
        context.startActivity(intent);
    }

}
