package com.yy.pushsvc.util;

import android.content.Context;
import android.util.Log;

import com.yy.pushsvc.YYPush;

import org.chromium.net.CronetEngine;
import org.chromium.net.ExperimentalCronetEngine;
import org.chromium.net.urlconnection.CronetHttpURLConnection;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class CronetUtils {
    private static final String TAG = "CronetUtils:";
    private static final int REQUEST_USE_QUIC = 0;
    private static final int REQUEST_USE_HTTP = 1;

    public interface Callback {
        void onSuccess(int code, String result);
        void onFailed(int code, String error);
    }

    private  String HOSTNAME_TEST = "push-link-test." + YYPush.httpsDNS;
    private  String HOSTNAME_PRODUCT = "push-link." + YYPush.httpsDNS;
    private static CronetUtils sInstance;
    private ExperimentalCronetEngine mCronetEngine;
    private final String hostName;
    private Context mContext;
    private InputStream ins;
    boolean mIsHttp = false;

    private CronetUtils(boolean isTestEvn) {
        hostName = isTestEvn? HOSTNAME_TEST : HOSTNAME_PRODUCT;
    }

    public static synchronized CronetUtils getsInstance(boolean isTestEvn) {
        if (sInstance == null) {
            sInstance = new CronetUtils(isTestEvn);
        }
        return sInstance;
    }

    public synchronized void init(Context context , boolean isHttp ) {
        mContext = context;
        mIsHttp = isHttp;
        if (!isHttp) {
            if (mCronetEngine == null) {
                try {
                    ExperimentalCronetEngine.Builder builder =
                            new ExperimentalCronetEngine.Builder(context);
                    builder.enableHttpCache(CronetEngine.Builder.HTTP_CACHE_IN_MEMORY,
                            100 * 1024)
                            .enableHttp2(true)
                            .enableQuic(true)
                            .addQuicHint(hostName, 80, 80);

                    JSONObject quicParams = new JSONObject()
                            .put("connection_options", "PACE,IW10,FOO,DEADBEEF")
                            .put("host_whitelist", hostName)
                            .put("max_server_configs_stored_in_properties", 2)
                            .put("delay_tcp_race", true)
                            .put("max_number_of_lossy_connections", 10)
                            .put("packet_loss_threshold", 0.5)
                            .put("idle_connection_timeout_seconds", 300)
                            .put("close_sessions_on_ip_change", false)
                            .put("migrate_sessions_on_network_change", false)
                            .put("migrate_sessions_early", false)
                            .put("race_cert_verification", true);
                    JSONObject experimentalOptions = new JSONObject().put("QUIC", quicParams);
                    builder.setExperimentalOptions(experimentalOptions.toString());
                    mCronetEngine = builder.build();
                } catch (Throwable e) {
                    PushLog.inst().log("quicParams exception:" + Log.getStackTraceString(e));
                    mCronetEngine = null;
                    mIsHttp = true;
                }
            }
        }
    }

    public void getOutlineMsgFromNet(boolean supportSSL,String reqParams,
                                     Callback callback) {
        Callback msgCallback = callback == null? new Callback() {
            @Override public void onSuccess(int code, String result) { }
            @Override public void onFailed(int code, String error) { }
        } : callback;
        try {
            final String[] protocols = {"http", "https"};
            final String url = new StringBuffer(supportSSL? protocols[1] : protocols[0])
                    .append("://")
                    .append(hostName)
                    .append("/push/pullMsg?")
                    .append(reqParams)
                    .toString();
            PushLog.inst().log(TAG +"getOutlineMsgFromNet url:" + url);
            if (mIsHttp) {
                useHttp(url, msgCallback);
            } else {
                useQuic(url, msgCallback);
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + "getOutlineMsgFromNet exception!" + Log.getStackTraceString(e));
        }
    }

    private void useHttp(String url, Callback callback) throws IOException {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection) new URL(url).openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10 * 1000);
            conn.setReadTimeout(10 * 1000);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.addRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("User-Agent", "HttpUrlConnection/Android");
            conn.setDoInput(true);

            int rspCode = conn.getResponseCode();
            switch (rspCode) {
                case 200:
                    PushLog.inst().log(TAG + "useHttp onRequest Success");
                    ins = conn.getInputStream();
                    String result = StringUtil.inStream2String(ins);
                    callback.onSuccess(rspCode, result);
                    break;
                default:
                    PushLog.inst().log(TAG + "useHttp onRequest Failed");
                    callback.onFailed(rspCode, conn.getResponseMessage());
                    break;
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + "useHttp exception!" + Log.getStackTraceString(e));
            callback.onFailed(400, conn.getResponseMessage());
        } finally {
            if (ins != null) {
                ins.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private void useQuic(String url, Callback callback) throws IOException {
        CronetHttpURLConnection mCronetHttpUrlConnection = null;
        try {
            mCronetHttpUrlConnection = new CronetHttpURLConnection(new URL(url), mCronetEngine);
            mCronetHttpUrlConnection.setConnectTimeout(5 * 1000);
            mCronetHttpUrlConnection.setRequestProperty("Content-Type", "application/json");
            mCronetHttpUrlConnection.addRequestProperty("Connection", "Keep-Alive");
            mCronetHttpUrlConnection.setRequestProperty("User-Agent", "HttpUrlConnection/Android");

            mCronetHttpUrlConnection.connect();
            final int rspCode = mCronetHttpUrlConnection.getResponseCode();
            switch (rspCode) {
                case 200:
                    PushLog.inst().log(TAG + "useQuic onRequest Success");
                    ins = mCronetHttpUrlConnection.getInputStream();
                    String result = StringUtil.inStream2String(ins);
                    callback.onSuccess(rspCode, result);
                    break;
                default:
                    PushLog.inst().log(TAG + "useQuic onRequest Failed");
                    callback.onFailed(rspCode, mCronetHttpUrlConnection.getResponseMessage());
                    break;
            }

        } catch (Throwable e) {
            PushLog.inst().log(TAG + "useHttp exception!" + Log.getStackTraceString(e));
        } finally {
            if (ins != null) {
                ins.close();
            }
            if (mCronetHttpUrlConnection != null) {
                mCronetHttpUrlConnection.disconnect();
            }
        }
    }

}
