package com.yy.pushsvc.util;

import android.app.ActivityManager;
import android.app.ActivityManager.RunningAppProcessInfo;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.text.TextUtils;
import android.util.Log;

import com.yy.pushsvc.YYPush;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AppPackageUtil {

    private static final String TAG = "AppPackageUtil";
    private static int mAppKey = 0;
    static Map<String, String> propertyMap = new ConcurrentHashMap<>();

    public static String getCurrentProcessName(Context context) {
        try {
            int pid = android.os.Process.myPid();
            ActivityManager activityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
            if (activityManager != null) {
                for (RunningAppProcessInfo appProcess : activityManager.getRunningAppProcesses()) {
                    if (appProcess.pid == pid) {
                        return appProcess.processName;
                    }
                }
            }
            return "";
        } catch (Exception e) {
            PushLog.inst().log("AppPackageUtil.getCurrentProcessName error: " + StringUtil.exception2String(e));
            return "";
        }
    }

    public static int getAppKey(Context context) {
        if (mAppKey > 0) {
            return mAppKey;
        }
        if (context == null) {
            return 0;
        }
        try {
            ApplicationInfo appInfo = context.getPackageManager()
                    .getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            mAppKey = appInfo.metaData.getInt("appKey");
            return mAppKey;
        } catch (Exception e) {
            PushLog.inst().log("AppPackageUtil.getAppKey error: " + StringUtil.exception2String(e));
            return 0;
        }
    }

    public static String getMac(Context context) {
        try {
            WifiManager wifiMgr = (WifiManager) context.getApplicationContext().getSystemService(Context.WIFI_SERVICE);
            if (wifiMgr != null) {
                WifiInfo connectionInfo = wifiMgr.getConnectionInfo();
                if (connectionInfo != null) {
                    String macAddress = connectionInfo.getMacAddress();
                    if (macAddress != null) {
                        try {
                            String macStr = URLEncoder.encode(macAddress, "UTF-8");
                            if (macStr != null) {
                                return macStr;
                            }
                        } catch (Exception e1) {
                            PushLog.inst().log("AppPackageUtil.getMac error: " + StringUtil.exception2String(e1));
                        }
                    }
                }
            }
            return "YY_FAKE_MAC";
        } catch (Exception e) {
            PushLog.inst().log("AppPackageUtil.getMac error: " + StringUtil.exception2String(e));
            return "YY_FAKE_MAC";
        }
    }

    public static String getJiGuangAppKey(Context context) {
        String appKey = null;
        try {
            ApplicationInfo appInfo = context.getPackageManager()
                    .getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            if (appInfo.metaData.containsKey("JPUSH_APPKEY")) {
                appKey = appInfo.metaData.getString("JPUSH_APPKEY");
            } else {
                PushLog.inst().log("AppPackageUtil.getJiGuangAppKey metaData has no JPUSH_APPKEY");
            }
            return appKey;
        } catch (Exception e) {
            PushLog.inst().log("AppPackageUtil.getGetuiAppId error: " + StringUtil.exception2String(e));
            return null;
        }
    }

    public static boolean isLimitRegisterJiGuangPushSdk() {
        if (SystemUtil.isXiaoMi() || SystemUtil.isHuaWei()) {
            PushLog.inst().log(TAG + ".isLimitRegisterJiGuangPushSdk xiaomi and huawei dont register jiguang");
            return true;
        } else {
            return false;
        }
    }

    public static boolean isGtServiceProcess(Context context) {
        return (context.getPackageName() + ":pushservice").equals(AppPackageUtil.getCurrentProcessName(context));
    }

    public static String getEmuiVersion() {
        String emuiVerion = "";
        Class<?>[] clsArray = new Class<?>[]{String.class};
        Object[] objArray = new Object[]{"ro.build.version.emui"};
        try {
            Class<?> systemPropertiesClass = Class.forName("android.os.SystemProperties");
            Method get = systemPropertiesClass.getDeclaredMethod("get", clsArray);
            String version = (String) get.invoke(systemPropertiesClass, objArray);
            PushLog.inst().log(TAG + ".getEmuiVersion version:" + version);
            if (!TextUtils.isEmpty(version)) {
                return version;
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + ".getEmuiVersion exception:" + Log.getStackTraceString(e));
        }
        return emuiVerion;
    }

    public static String getSystemProperty(String propName) {
        String line = "";
        BufferedReader input = null;
        try {
            if (propertyMap != null && propertyMap.containsKey(propName)) {
                line = propertyMap.get(propName);
                if (!TextUtils.isEmpty(line)) {
                    return line;
                }
            }
            Process p = Runtime.getRuntime().exec("getprop " + propName);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            line = input.readLine();
            input.close();
            propertyMap.put(propName, line);
        } catch (Throwable ex) {
            PushLog.inst()
                    .log(TAG + "Unable to read sysprop " + propName + Log.getStackTraceString(ex));
        } finally {
            if (input != null) {
                try {
                    input.close();
                } catch (Throwable e) {
                    PushLog.inst().log(TAG + "Exception while closing InputStream " +
                            Log.getStackTraceString(e));
                }
            }
        }
        return line;
    }

    public static synchronized String getAppVersionName() {
        try {
            Context context = YYPush.getInstace().getContext();
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(
                    context.getPackageName(), 0);
            return packageInfo.versionName;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static synchronized String getAppVersionCode() {
        try {
            Context context = YYPush.getInstace().getContext();
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(
                    context.getPackageName(), 0);
            return packageInfo.versionCode + "";
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
}
