package com.yy.pushsvc.util;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;

import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.yunlog.KLogW;

public class ActivityLifecycleHelper {

    static boolean isForground = false;

    public static boolean isForground() {
        return isForground;
    }

    public static void setActivityLifecycleCallback(Context context) {
        if (!(context instanceof Application)) {
            context = context.getApplicationContext();
        }
        isForground =! NotificationUtil.isAppIsInBackground(context);
        if (context instanceof Application) {
            ((Application) context).registerActivityLifecycleCallbacks(
                            new Application.ActivityLifecycleCallbacks() {
                                private int appCount = 0;

                                @Override
                                public void onActivityCreated(Activity activity,
                                                              Bundle savedInstanceState) {

                                }

                                @Override
                                public void onActivityStarted(Activity activity) {
                                    appCount++;
                                    if (!isForground) {
                                        isForground = true;
                                        onForegroundChange(isForground);
                                    }
                                }

                                @Override
                                public void onActivityResumed(Activity activity) {

                                }

                                @Override
                                public void onActivityPaused(Activity activity) {

                                }

                                @Override
                                public void onActivityStopped(Activity activity) {
                                    appCount--;
                                    if (!isForgroundAppValue()) {
                                        isForground = false;
                                        onForegroundChange(isForground);
                                    }
                                }

                                @Override
                                public void onActivitySaveInstanceState(Activity activity,
                                                                        Bundle outState) {

                                }

                                @Override
                                public void onActivityDestroyed(Activity activity) {

                                }

                                private boolean isForgroundAppValue() {
                                    return appCount > 0;
                                }
                            });
        }
    }

    private static void onForegroundChange(boolean isForground) {
        try{
            KLogW.i(YYPushStatisticEvent.REPORT_FOREGROUND, isForground + "");
            PushReporter.getInstance()
                    .reportEvent(YYPushStatisticEvent.REPORT_FOREGROUND + "_" + isForground);
        }catch (Throwable t){
            PushLog.inst().log("ActivityLifecycleHelper" + ".registerNetWorkChangeReceiver//erro=" + t);
        }
    }
}
