package com.yy.pushsvc.undisturb;

import com.yy.pushsvc.IAcquireAppState;
import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.util.PushLog;

import org.json.JSONObject;

import java.util.HashMap;

/**
 * Created by GuanYuFeng
 * on 2020/9/7
 */
public class UndisturbManager {
    private static final String TAG ="UndisturbManager";
    private static final String push_source = "push_source";
    private static UndisturbEntity entity;

    /**
     * 消息免打扰功能
     *
     * @param payload
     * @return true;该条push命中免打扰
     */
    public static  boolean isUndisturb(JSONObject payload) {
        boolean undisturb = false;
        try {
            int pushSource = payload.optInt(push_source);
            IAcquireAppState acquireAppState = YYPush.getInstace().getAcquireAppState();
            if (entity == null) {
                entity = acquireAppState.getUndisturbEntity();
            }
            if (entity != null) {
                PushLog.inst().log(TAG + ",UndisturbEntity = " + entity);
                if (entity.unDisturbOn) {
                    undisturb = true;
                } else {
                    HashMap<Integer, Boolean> pushSourceOn = entity.pushSourceOn;
                    if (pushSourceOn != null) {
                        if (pushSourceOn.containsKey(pushSource)) {
                            boolean open = pushSourceOn.get(pushSource);
                            undisturb = open;
                        }
                    }
                }
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + ",isUndisturb,erro = " + e);
        }
        return undisturb;
    }
}
