package com.yy.pushsvc.thirdparty;

import android.content.Context;

import com.xiaomi.mipush.sdk.ErrorCode;
import com.xiaomi.mipush.sdk.MiPushClient;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.PushMessageReceiver;
import com.yy.pushsvc.receiver.YYPushCallBackManager;
import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.report.TokenRegisterState;
import com.yy.pushsvc.report.YYPushDeviceInfoHttp;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.StringUtil;
import com.yy.pushsvc.util.YYPushConsts;
import com.yy.pushsvc.util.YYPushStatisticEvent;
import com.yy.pushsvc.yunlog.KLogW;

import org.json.JSONObject;

import java.util.List;

public class PushXiaomiPushReceiver extends PushMessageReceiver {

    @Override
    public final void onReceivePassThroughMessage(Context context, MiPushMessage message) {
        try {
            String msgString = message.getContent();
            TokenStore.getInstance().dispacthMsg(context, ThirdPartyPushType.PUSH_TYPE_XIAOMI, msgString);
        } catch (Exception e) {
            PushLog.inst().log("PushXiaomiPushReceiver.onReceivePassThroughMessage unmarshall failed: " +
                    StringUtil.exception2String(e));
        }
    }

    @Override
    public final void onNotificationMessageArrived(Context context, MiPushMessage message) {
        try {
            String msgString = message.getContent();
            TokenStore.getInstance().dispatchNotification(context, YYPushConsts.PUSH_BROADCAST_NOTIFICATION_ARRIVED,
                    ThirdPartyPushType.PUSH_TYPE_XIAOMI,new JSONObject(msgString));
        } catch (Exception e) {
            PushLog.inst().log("PushXiaomiPushReceiver.onNotificationMessageArrived unmarshall failed: " +
                    StringUtil.exception2String(e));
        }
    }

    @Override
    public final void onNotificationMessageClicked(Context context, MiPushMessage message) {
        try {
            String msgString = message.getContent();
            TokenStore.getInstance().dispatchNotification(context, YYPushConsts.PUSH_BROADCAST_NOTIFICATION_CLICKED,
                    ThirdPartyPushType.PUSH_TYPE_XIAOMI, new JSONObject(msgString));
        } catch (Exception e) {
            PushLog.inst().log("PushXiaomiPushReceiver.onNotificationMessageClicked unmarshall failed: " +
                    StringUtil.exception2String(e));
        }
    }

    @Override
    public final void onReceiveRegisterResult(Context context, MiPushCommandMessage message) {
        String command = message.getCommand();
        List<String> arguments = message.getCommandArguments();
        String xiaomiToken = ((arguments != null && arguments.size() > 0) ? arguments.get(0) : null);
        if (MiPushClient.COMMAND_REGISTER.equals(command)) {
            if (message.getResultCode() == ErrorCode.SUCCESS) {

                PushLog.inst().log("PushXiaomiPushReceiver.onReceiveRegisterResult regid is " + xiaomiToken);

                if (xiaomiToken != null) {
                    //上报小米注册成功事件到海度
                    TokenRegisterState.getInstance().addRegisterTokenState(ThirdPartyPushType.PUSH_TYPE_XIAOMI,
                            true, null, null);
                    PushReporter.getInstance().reportEvent(YYPushStatisticEvent.REGISTER_XIAOMI_TOKEN_SUCCESS);
                    KLogW.i(YYPushStatisticEvent.REGISTER_XIAOMI_TOKEN_SUCCESS,xiaomiToken);
                }
                if (xiaomiToken == null) {
                    //上报小米注册失败到海度
                    TokenRegisterState.getInstance().addRegisterTokenState(ThirdPartyPushType.PUSH_TYPE_XIAOMI,
                            false, YYPushConsts.RES_FAIL, "xiaomiToken is null reason:" + message.getReason());
                    PushReporter.getInstance().reportEvent(YYPushStatisticEvent.REGISTER_XIAOMI_TOKEN_FAILURE,
                            "xiaomiToken is null," + message.getReason());
                    KLogW.i(YYPushStatisticEvent.REGISTER_XIAOMI_TOKEN_FAILURE,xiaomiToken);
                    return;

                }
                YYPushDeviceInfoHttp.getInstance().addThirdpartyToken(ThirdPartyPushType.PUSH_TYPE_XIAOMI, xiaomiToken);
                TokenStore.getInstance().dispatchToken(context, ThirdPartyPushType.PUSH_TYPE_XIAOMI, xiaomiToken);


                String newXiaomiToken = "xiaomi:" + xiaomiToken;
                if (YYPushCallBackManager.getInstance().getPushTokenCallBack() != null) {
                    YYPushCallBackManager.getInstance().getPushTokenCallBack().onSuccess(newXiaomiToken);
                    PushLog.inst().log("PushXiaomiPushReceiver.onReceiveRegisterResult, " +
                            "call IYYPushTokenCallback.onSuccess, " + "token = " + newXiaomiToken);
                }
            } else {   //上报小米注册失败到鹰眼海度
                TokenRegisterState.getInstance().addRegisterTokenState(ThirdPartyPushType.PUSH_TYPE_XIAOMI, false,
                        String.valueOf(message.getResultCode()), message.getReason());
                PushReporter.getInstance().reportEvent(YYPushStatisticEvent.REGISTER_XIAOMI_TOKEN_FAILURE,
                        "xiaomiToken is null," + message.getReason());
                PushLog.inst().log("PushXiaomiPushReceiver.onReceiveRegisterResult failed, errorcode = " +
                        message.getResultCode() + ", message = " + message.toString());
            }
        } else {
            //上报小米注册失败到鹰眼海度
            TokenRegisterState.getInstance()
                    .addRegisterTokenState(ThirdPartyPushType.PUSH_TYPE_XIAOMI, false, command, message.getReason());
            PushReporter.getInstance().reportEvent(YYPushStatisticEvent.REGISTER_XIAOMI_TOKEN_FAILURE,
                    "command is " + command + ", reason:" + message.getReason());
            PushLog.inst().log("PushXiaomiPushReceiver.onReceiveRegisterResult command failed, command = " + command
                    + ", reason:" + message.getReason());
        }
    }

}
