package com.yy.pushsvc.thirdparty;

import com.heytap.mcssdk.callback.PushAdapter;
import com.heytap.mcssdk.mode.SubscribeResult;
import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.receiver.YYPushCallBackManager;
import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.report.TokenRegisterState;
import com.yy.pushsvc.report.YYPushDeviceInfoHttp;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.YYPushConsts;
import com.yy.pushsvc.util.YYPushStatisticEvent;

import java.util.List;

/**
 * Created by DW on 2018/5/10.
 * Description
 */

public class PushOppoRegisterCallBack extends PushAdapter {
    private static final String TAG = "PushOppoRegisterCallBac";

    @Override
    public void onRegister(final int code, final String s) {
        if (code == 0) {
            PushThreadPool.getPool().execute(new Runnable() {
                @Override
                public void run() {
                    String newOppoToken = "oppo:" + s;
                    PushLog.inst().log(TAG + ".onRegister sucess, oppo token:" +  newOppoToken);
                    //上报oppo注册成功到鹰眼海度
                    TokenRegisterState.getInstance().addRegisterTokenState(ThirdPartyPushType.PUSH_TYPE_OPPO,
                            true, null, null);
                    TokenStore.getInstance().dispatchToken(YYPush.getInstace().getContext(),
                            ThirdPartyPushType.PUSH_TYPE_OPPO, s);

                    YYPushDeviceInfoHttp.getInstance().addThirdpartyToken(ThirdPartyPushType.PUSH_TYPE_OPPO, s);
                    PushReporter.getInstance().reportEvent(YYPushStatisticEvent.REGISTER_OPPO_TOKEN_SUCCESS);

                    if (YYPushCallBackManager.getInstance().getPushTokenCallBack() != null) {
                        YYPushCallBackManager.getInstance().getPushTokenCallBack().onSuccess(newOppoToken);
                    }
                }
            });

        } else {
            PushThreadPool.getPool().execute(new Runnable() {
                @Override
                public void run() {
                    try {
                        TokenRegisterState.getInstance()
                                .addRegisterTokenState(ThirdPartyPushType.PUSH_TYPE_OPPO,
                                        false, YYPushConsts.RES_FAIL, "onToken is null");
                        PushReporter.getInstance()
                                .reportEvent(YYPushStatisticEvent.REGISTER_OPPO_TOKEN_FAILURE,
                                        "onToken " +
                                                "is null");
                        PushLog.inst()
                                .log(TAG + ".onRegister fail, oppo code:" + code + ", msg = " + s);
                    } catch (Throwable t) {
                        PushLog.inst().log(TAG + ".onRegister fail,erro:" + t);
                    }
                }
            });
        }
    }

    @Override
    public void onUnRegister(int code) {
        super.onUnRegister(code);
    }

    @Override
    public void onGetAliases(int code, List<SubscribeResult> list) {
        super.onGetAliases(code, list);
    }

    @Override
    public void onSetAliases(int code, List<SubscribeResult> list) {
        super.onSetAliases(code, list);
    }

    @Override
    public void onUnsetAliases(int code, List<SubscribeResult> list) {
        super.onUnsetAliases(code, list);
    }

    @Override
    public void onSetTags(int code, List<SubscribeResult> list) {
        super.onSetTags(code, list);
    }

    @Override
    public void onUnsetTags(int code, List<SubscribeResult> list) {
        super.onUnsetTags(code, list);
    }

    @Override
    public void onGetTags(int code, List<SubscribeResult> list) {
        super.onGetTags(code, list);
    }

    @Override
    public void onGetPushStatus(int code, int i1) {
        super.onGetPushStatus(code, i1);
    }

    @Override
    public void onGetNotificationStatus(int code, int i1) {
        super.onGetNotificationStatus(code, i1);
    }

    @Override
    public void onSetPushTime(int code, String s) {
        super.onSetPushTime(code, s);
    }
}
