package com.yy.pushsvc.thirdparty;

import android.content.Context;
import android.util.Log;

import com.heytap.mcssdk.PushService;
import com.heytap.mcssdk.mode.AppMessage;
import com.heytap.mcssdk.mode.CommandMessage;
import com.heytap.mcssdk.mode.SptDataMessage;

/**
 * Created by DW on 2018/5/11.
 * Description
 */

public class PushOppoMsgService extends PushService {
    private static final String TAG = "PushOppoMsgService";

    /**
     * 普通应用消息
     *
     * @param context
     * @param appMessage
     */
    @Override
    public void processMessage(Context context, AppMessage appMessage) {
        super.processMessage(context, appMessage);
        String content = appMessage.getContent();
        Log.e(TAG, "processMessage, AppMessage:" + content);
    }

    /**
     * 透传消息处理，应用可以打开页面或者执行命令
     *
     * @param context
     * @param sptDataMessage
     */
    @Override
    public void processMessage(Context context, SptDataMessage sptDataMessage) {
        super.processMessage(context, sptDataMessage);
        String content = sptDataMessage.getContent();
        Log.e(TAG, "processMessage, SptDataMessage:" + content);
    }

    /**
     * 命令消息，主要是服务器对客户端调用的反馈
     *
     * @param context
     * @param commandMessage
     */
    @Override
    public void processMessage(Context context, CommandMessage commandMessage) {
        super.processMessage(context, commandMessage);
        String content = commandMessage.getContent();
        int command = commandMessage.getCommand();
        String param = commandMessage.getParams();
        Log.e(TAG, "processMessage, CommandMessage:" + content + ", command:" + command + ",params = " + param);
    }

}
