package com.yy.pushsvc.thirdparty;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;

import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.StringUtil;
import com.yy.pushsvc.util.YYPushConsts;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by DW on 2018/5/10.
 * Description oppo点击
 */

public class PushOppoActivity extends Activity {
    private static final String TAG = "PushOppoActivity";

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        PushThreadPool.getPool().execute(new Runnable() {
            @Override
            public void run() {
                handleOnCreate();
            }
        });
    }

    @Override
    protected void onStart() {
        try {
            super.onStart();
            if (!isFinishing()) {
                finish();
            }
            setVisible(true);
            Log.e(TAG, "onStart()");
        } catch (Throwable t) {
            Log.e(TAG, "onStart: erro= " + t);
        }
    }

    private void handleOnCreate() {
        try {
            Log.e(TAG, "onCreate: startActivity");
            PushLog.inst().log(TAG + ".onCreate:StartPushOppoActivity");
            PushReporter.getInstance().init(this.getApplicationContext());
            TokenStore.getInstance().init(this.getApplicationContext());
            parseIntent(getIntent());
            this.finish();
        } catch (Exception e) {
            PushLog.inst().log(TAG + ".onCreate, exception:" + StringUtil.exception2String(e));
        }
    }

    private void parseIntent(Intent intent) {
        try {
            long msgid = 0;
            long pushid = 0;
            String payload = null;
            if (intent.hasExtra("msgid")) {
                msgid = Long.parseLong(intent.getStringExtra("msgid"));
            } else {
                msgid = 0;
            }
            if (intent.hasExtra("payload")) {
                payload = intent.getStringExtra("payload");
            } else {
                payload = "";
            }
            if (intent.hasExtra("pushid")) {
                pushid = Long.parseLong(intent.getStringExtra("pushid"));
            } else {
                pushid = 0;
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msgid", msgid);
            jsonObject.put("pushid", pushid);
            jsonObject.put("payload", payload);
            TokenStore.getInstance().init(this);
            TokenStore.getInstance().dispatchNotification(this.getApplicationContext(),
                    YYPushConsts.PUSH_BROADCAST_NOTIFICATION_CLICKED,
                    ThirdPartyPushType.PUSH_TYPE_OPPO, jsonObject);
            PushLog.inst()
                    .log(TAG + ".parseIntent, msgid:" + msgid + ",pushid=" + pushid + ", payload:" +
                            payload);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }
}
